/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress;

import com.google.common.util.concurrent.Uninterruptibles;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import org.apache.cassandra.stress.Operation;
import org.apache.cassandra.stress.WorkManager;
import org.apache.cassandra.stress.operations.OpDistribution;
import org.apache.cassandra.stress.operations.OpDistributionFactory;
import org.apache.cassandra.stress.report.StressMetrics;
import org.apache.cassandra.stress.settings.SettingsCommand;
import org.apache.cassandra.stress.settings.StressSettings;
import org.apache.cassandra.stress.util.ResultLogger;
import org.apache.cassandra.utils.Clock;
import org.jctools.queues.SpscArrayQueue;
import org.jctools.queues.SpscUnboundedArrayQueue;

public class StressAction
implements Runnable {
    private final StressSettings settings;
    private final ResultLogger output;

    public StressAction(StressSettings settings, ResultLogger out) {
        this.settings = settings;
        this.output = out;
    }

    @Override
    public void run() {
        boolean success;
        this.settings.maybeCreateKeyspaces();
        if (this.settings.command.count == 0L) {
            this.output.println("N=0: SCHEMA CREATED, NOTHING ELSE DONE.");
            this.settings.disconnect();
            return;
        }
        this.output.println("Sleeping 2s...");
        Uninterruptibles.sleepUninterruptibly((long)2L, (TimeUnit)TimeUnit.SECONDS);
        if (!this.settings.command.noWarmup) {
            this.warmup(this.settings.command.getFactory(this.settings));
        }
        if (this.settings.command.truncate == SettingsCommand.TruncateWhen.ONCE || this.settings.rate.threadCount != -1 && this.settings.command.truncate == SettingsCommand.TruncateWhen.ALWAYS) {
            this.settings.command.truncateTables(this.settings);
        }
        if (this.settings.rate.threadCount == -1) {
            this.output.println("Thread count was not specified");
        }
        UniformRateLimiter rateLimiter = null;
        if (this.settings.rate.opsPerSecond > 0) {
            rateLimiter = new UniformRateLimiter(this.settings.rate.opsPerSecond);
        }
        if (this.settings.rate.minThreads > 0) {
            success = this.runMulti(this.settings.rate.auto, rateLimiter);
        } else {
            boolean bl = success = null != this.run(this.settings.command.getFactory(this.settings), this.settings.rate.threadCount, this.settings.command.count, this.settings.command.duration, rateLimiter, this.settings.command.durationUnits, this.output, false);
        }
        if (success) {
            this.output.println("END");
        } else {
            this.output.println("FAILURE");
        }
        this.settings.disconnect();
        if (!success) {
            throw new RuntimeException("Failed to execute stress action");
        }
    }

    private void warmup(OpDistributionFactory operations) {
        int iterations = (this.settings.command.count >= 0L ? Math.min(50000, (int)((double)this.settings.command.count * 0.25)) : 50000) * this.settings.node.nodes.size();
        if (iterations <= 0) {
            return;
        }
        int threads = 100;
        if (this.settings.rate.maxThreads > 0) {
            threads = Math.min(threads, this.settings.rate.maxThreads);
        }
        if (this.settings.rate.threadCount > 0) {
            threads = Math.min(threads, this.settings.rate.threadCount);
        }
        for (OpDistributionFactory single : operations.each()) {
            this.output.println(String.format("Warming up %s with %d iterations...", single.desc(), iterations));
            boolean success = null != this.run(single, threads, iterations, 0L, null, null, ResultLogger.NOOP, true);
            if (success) continue;
            throw new RuntimeException("Failed to execute warmup");
        }
    }

    private boolean runMulti(boolean auto, UniformRateLimiter rateLimiter) {
        if (this.settings.command.targetUncertainty >= 0.0) {
            this.output.println("WARNING: uncertainty mode (err<) results in uneven workload between thread runs, so should be used for high level analysis only");
        }
        int prevThreadCount = -1;
        int threadCount = this.settings.rate.minThreads;
        ArrayList<StressMetrics> results = new ArrayList<StressMetrics>();
        ArrayList<String> runIds = new ArrayList<String>();
        do {
            StressMetrics result;
            this.output.println("");
            this.output.println(String.format("Running with %d threadCount", threadCount));
            if (this.settings.command.truncate == SettingsCommand.TruncateWhen.ALWAYS) {
                this.settings.command.truncateTables(this.settings);
            }
            if ((result = this.run(this.settings.command.getFactory(this.settings), threadCount, this.settings.command.count, this.settings.command.duration, rateLimiter, this.settings.command.durationUnits, this.output, false)) == null) {
                return false;
            }
            results.add(result);
            if (prevThreadCount > 0) {
                System.out.println(String.format("Improvement over %d threadCount: %.0f%%", prevThreadCount, 100.0 * this.averageImprovement(results, 1)));
            }
            runIds.add(threadCount + " threadCount");
            prevThreadCount = threadCount;
            threadCount = threadCount < 16 ? (threadCount *= 2) : (int)((double)threadCount * 1.5);
            if (!results.isEmpty() && threadCount > this.settings.rate.maxThreads) break;
            if (!this.settings.command.type.updates) continue;
            this.output.println("Sleeping for 15s");
            try {
                Thread.sleep(15000L);
            }
            catch (InterruptedException e) {
                return false;
            }
        } while (!auto || this.hasAverageImprovement(results, 3, 0.0) && this.hasAverageImprovement(results, 5, this.settings.command.targetUncertainty));
        StressMetrics.summarise(runIds, results, this.output);
        return true;
    }

    private boolean hasAverageImprovement(List<StressMetrics> results, int count, double minImprovement) {
        return results.size() < count + 1 || this.averageImprovement(results, count) >= minImprovement;
    }

    private double averageImprovement(List<StressMetrics> results, int count) {
        double improvement = 0.0;
        for (int i = results.size() - count; i < results.size(); ++i) {
            double prev = results.get(i - 1).opRate();
            double cur = results.get(i).opRate();
            improvement += (cur - prev) / prev;
        }
        return improvement / (double)count;
    }

    private StressMetrics run(OpDistributionFactory operations, int threadCount, long opCount, long duration, UniformRateLimiter rateLimiter, TimeUnit durationUnits, ResultLogger output, boolean isWarmup) {
        int i;
        output.println(String.format("Running %s with %d threads %s", operations.desc(), threadCount, durationUnits != null ? duration + " " + durationUnits.toString().toLowerCase() : (opCount > 0L ? "for " + opCount + " iteration" : "until stderr of mean < " + this.settings.command.targetUncertainty)));
        WorkManager workManager = opCount < 0L ? new WorkManager.ContinuousWorkManager() : new WorkManager.FixedWorkManager(opCount);
        StressMetrics metrics = new StressMetrics(output, this.settings.log.intervalMillis, this.settings);
        CountDownLatch releaseConsumers = new CountDownLatch(1);
        CountDownLatch done = new CountDownLatch(threadCount);
        CountDownLatch start = new CountDownLatch(threadCount);
        Consumer[] consumers = new Consumer[threadCount];
        for (i = 0; i < threadCount; ++i) {
            consumers[i] = new Consumer(operations, isWarmup, done, start, releaseConsumers, workManager, metrics, rateLimiter);
        }
        for (i = 0; i < threadCount; ++i) {
            consumers[i].start();
        }
        try {
            start.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Unexpected interruption", e);
        }
        if (rateLimiter != null) {
            rateLimiter.start();
        }
        releaseConsumers.countDown();
        metrics.start();
        if (durationUnits != null) {
            Uninterruptibles.sleepUninterruptibly((long)duration, (TimeUnit)durationUnits);
            workManager.stop();
        } else if (opCount <= 0L) {
            try {
                metrics.waitUntilConverges(this.settings.command.targetUncertainty, this.settings.command.minimumUncertaintyMeasurements, this.settings.command.maximumUncertaintyMeasurements);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            workManager.stop();
        }
        try {
            done.await();
            metrics.stop();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (metrics.wasCancelled()) {
            return null;
        }
        metrics.summarise();
        boolean success = true;
        for (Consumer consumer : consumers) {
            success &= consumer.success;
        }
        if (!success) {
            return null;
        }
        return metrics;
    }

    public class Consumer
    extends Thread
    implements MeasurementSink {
        private final StreamOfOperations opStream;
        private final StressMetrics metrics;
        private volatile boolean success = true;
        private final CountDownLatch done;
        private final CountDownLatch start;
        private final CountDownLatch releaseConsumers;
        public final Queue<OpMeasurement> measurementsRecycling;
        public final Queue<OpMeasurement> measurementsReporting;

        public Consumer(OpDistributionFactory operations, boolean isWarmup, CountDownLatch done, CountDownLatch start, CountDownLatch releaseConsumers, WorkManager workManager, StressMetrics metrics, UniformRateLimiter rateLimiter) {
            OpDistribution opDistribution = operations.get(isWarmup, this);
            this.done = done;
            this.start = start;
            this.releaseConsumers = releaseConsumers;
            this.metrics = metrics;
            this.opStream = new StreamOfOperations(opDistribution, rateLimiter, workManager);
            this.measurementsRecycling = new SpscArrayQueue(8192);
            this.measurementsReporting = new SpscUnboundedArrayQueue(2048);
            metrics.add(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            try {
                sclient = null;
                jclient = null;
                clientType = StressAction.this.settings.mode.api;
                try {
                    switch (1.$SwitchMap$org$apache$cassandra$stress$settings$ConnectionAPI[clientType.ordinal()]) {
                        case 1: {
                            jclient = StressAction.this.settings.getJavaDriverClient();
                            ** break;
lbl10:
                            // 1 sources

                            break;
                        }
                        case 2: {
                            sclient = StressAction.this.settings.getSimpleNativeClient();
                            ** break;
lbl14:
                            // 1 sources

                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                }
                finally {
                    this.start.countDown();
                }
                this.releaseConsumers.await();
                while (true) {
                    if ((op = this.opStream.nextOp()) == null) {
                        break;
                    }
                    try {
                        switch (1.$SwitchMap$org$apache$cassandra$stress$settings$ConnectionAPI[clientType.ordinal()]) {
                            case 1: {
                                op.run(jclient);
                                break;
                            }
                            case 2: {
                                op.run(sclient);
                                break;
                            }
                            default: {
                                throw new IllegalStateException();
                            }
                        }
                    }
                    catch (Exception e) {
                        if (StressAction.this.output == null) {
                            System.err.println(e.getMessage());
                        } else {
                            StressAction.this.output.printException(e);
                        }
                        this.success = false;
                        this.opStream.abort();
                        this.metrics.cancel();
                        this.done.countDown();
                        return;
                    }
                }
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                this.success = false;
            }
            finally {
                this.done.countDown();
            }
        }

        @Override
        public void record(String opType, long intended, long started, long ended, long rowCnt, long partitionCnt, boolean err) {
            OpMeasurement opMeasurement = this.measurementsRecycling.poll();
            if (opMeasurement == null) {
                opMeasurement = new OpMeasurement();
            }
            opMeasurement.opType = opType;
            opMeasurement.intended = intended;
            opMeasurement.started = started;
            opMeasurement.ended = ended;
            opMeasurement.rowCnt = rowCnt;
            opMeasurement.partitionCnt = partitionCnt;
            opMeasurement.err = err;
            this.measurementsReporting.offer(opMeasurement);
        }
    }

    public static interface MeasurementSink {
        public void record(String var1, long var2, long var4, long var6, long var8, long var10, boolean var12);
    }

    public static class OpMeasurement {
        public String opType;
        public long intended;
        public long started;
        public long ended;
        public long rowCnt;
        public long partitionCnt;
        public boolean err;

        public String toString() {
            return "OpMeasurement [opType=" + this.opType + ", intended=" + this.intended + ", started=" + this.started + ", ended=" + this.ended + ", rowCnt=" + this.rowCnt + ", partitionCnt=" + this.partitionCnt + ", err=" + this.err + "]";
        }
    }

    private static class StreamOfOperations {
        private final OpDistribution operations;
        private final UniformRateLimiter rateLimiter;
        private final WorkManager workManager;

        public StreamOfOperations(OpDistribution operations, UniformRateLimiter rateLimiter, WorkManager workManager) {
            this.operations = operations;
            this.rateLimiter = rateLimiter;
            this.workManager = workManager;
        }

        Operation nextOp() {
            Operation op = this.operations.next();
            int partitionCount = op.ready(this.workManager);
            if (partitionCount == 0) {
                return null;
            }
            if (this.rateLimiter != null) {
                long now;
                long intendedTime = this.rateLimiter.acquire(partitionCount);
                op.intendedStartNs(intendedTime);
                while ((now = Clock.Global.nanoTime()) < intendedTime) {
                    LockSupport.parkNanos(intendedTime - now);
                }
            }
            return op;
        }

        void abort() {
            this.workManager.stop();
        }
    }

    private static class UniformRateLimiter {
        long start = Long.MIN_VALUE;
        final long intervalNs;
        final AtomicLong opIndex = new AtomicLong();

        UniformRateLimiter(int opsPerSec) {
            this.intervalNs = 1000000000 / opsPerSec;
        }

        void start() {
            this.start = Clock.Global.nanoTime();
        }

        long acquire(int partitionCount) {
            long currOpIndex = this.opIndex.getAndAdd(partitionCount);
            return this.start + currOpIndex * this.intervalNs;
        }
    }
}

