/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.time.Duration;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.wire.LongConverter;

public class MicroDurationLongConverter
implements LongConverter {
    @Override
    public long parse(CharSequence text) {
        Duration parse = Duration.parse(text);
        return parse.getSeconds() * 1000000L + (long)(parse.getNano() / 1000);
    }

    private Duration duration(long value) {
        return Duration.ofSeconds(value / 1000000L, value % 1000000L * 1000L);
    }

    @Override
    public void append(StringBuilder text, long value) {
        text.append(this.duration(value));
    }

    @Override
    public void append(Bytes<?> bytes, long value) {
        bytes.append((CharSequence)this.duration(value).toString());
    }
}

