/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.Method;
import java.util.function.Supplier;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.wire.AbstractMethodWriterInvocationHandler;
import net.openhft.chronicle.wire.MarshallableOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WriteDocumentContext;
import org.jetbrains.annotations.NotNull;

public class BinaryMethodWriterInvocationHandler
extends AbstractMethodWriterInvocationHandler {
    @NotNull
    private final Supplier<MarshallableOut> marshallableOutSupplier;
    private final boolean metaData;

    BinaryMethodWriterInvocationHandler(Class<?> tClass, boolean metaData, @NotNull MarshallableOut marshallableOut) {
        this(tClass, metaData, () -> marshallableOut);
    }

    @Deprecated
    public BinaryMethodWriterInvocationHandler(boolean metaData, Supplier<MarshallableOut> marshallableOutSupplier) {
        this(Object.class, metaData, marshallableOutSupplier);
    }

    public BinaryMethodWriterInvocationHandler(Class<?> tClass, boolean metaData, Supplier<MarshallableOut> marshallableOutSupplier) {
        super(tClass);
        this.marshallableOutSupplier = marshallableOutSupplier;
        this.metaData = metaData;
        this.recordHistory = marshallableOutSupplier.get().recordHistory();
    }

    @Override
    protected Object doInvoke(Object proxy, Method method, Object[] args) {
        if (method.getName().equals("writingDocument") && method.getParameterCount() == 0) {
            MarshallableOut marshallableOut = this.marshallableOutSupplier.get();
            return marshallableOut.writingDocument(this.metaData);
        }
        return super.doInvoke(proxy, method, args);
    }

    public boolean metaData() {
        return this.metaData;
    }

    @Override
    protected void handleInvoke(Method method, Object[] args) {
        boolean chained = method.getReturnType().isInterface();
        MarshallableOut marshallableOut = this.marshallableOutSupplier.get();
        try (WriteDocumentContext dc = (WriteDocumentContext)marshallableOut.acquireWritingDocument(this.metaData);){
            try {
                dc.chainedElement(chained);
                Wire wire = dc.wire();
                this.handleInvoke(method, args, wire);
                wire.padToCacheAlign();
            }
            catch (Throwable t) {
                dc.rollbackOnClose();
                throw Jvm.rethrow((Throwable)t);
            }
        }
    }
}

