/*
 * Decompiled with CFR 0.152.
 */
package org.github.jamm.utils;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Optional;

public final class MethodHandleUtils {
    public static Optional<MethodHandle> mayBeMethodHandle(Class<?> klass, String methodName) {
        try {
            Method method = klass.getMethod(methodName, new Class[0]);
            return Optional.of(MethodHandleUtils.methodHandle(method));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static MethodHandle methodHandle(Method method) throws IllegalAccessException {
        return MethodHandles.lookup().unreflect(method);
    }

    public static MethodHandle methodHandle(Field field) throws IllegalAccessException {
        return MethodHandles.lookup().unreflectGetter(field);
    }

    private MethodHandleUtils() {
    }
}

