/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cassandra.streaming.ProgressInfo;
import org.apache.cassandra.streaming.SessionSummary;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.streaming.StreamSummary;
import org.apache.cassandra.utils.FBUtilities;

public final class SessionInfo
implements Serializable {
    public final InetSocketAddress peer;
    public final int sessionIndex;
    public final InetSocketAddress connecting;
    public final Collection<StreamSummary> receivingSummaries;
    public final Collection<StreamSummary> sendingSummaries;
    public final StreamSession.State state;
    private final Map<String, ProgressInfo> receivingFiles = new ConcurrentHashMap<String, ProgressInfo>();
    private final Map<String, ProgressInfo> sendingFiles = new ConcurrentHashMap<String, ProgressInfo>();
    public final String failureReason;

    public SessionInfo(InetSocketAddress peer, int sessionIndex, InetSocketAddress connecting, Collection<StreamSummary> receivingSummaries, Collection<StreamSummary> sendingSummaries, StreamSession.State state, String failureReason) {
        this.peer = peer;
        this.sessionIndex = sessionIndex;
        this.connecting = connecting;
        this.receivingSummaries = ImmutableSet.copyOf(receivingSummaries);
        this.sendingSummaries = ImmutableSet.copyOf(sendingSummaries);
        this.state = state;
        this.failureReason = failureReason;
    }

    public SessionInfo(SessionInfo other) {
        this(other.peer, other.sessionIndex, other.connecting, other.receivingSummaries, other.sendingSummaries, other.state, other.failureReason);
    }

    public boolean isFailed() {
        return this.state == StreamSession.State.FAILED;
    }

    public boolean isAborted() {
        return this.state == StreamSession.State.ABORTED;
    }

    public void updateProgress(ProgressInfo newProgress) {
        assert (this.peer.equals(newProgress.peer));
        Map<String, ProgressInfo> currentFiles = newProgress.direction == ProgressInfo.Direction.IN ? this.receivingFiles : this.sendingFiles;
        currentFiles.put(newProgress.fileName, newProgress);
    }

    public Collection<ProgressInfo> getReceivingFiles() {
        return this.receivingFiles.values();
    }

    public Collection<ProgressInfo> getSendingFiles() {
        return this.sendingFiles.values();
    }

    public long getTotalFilesReceived() {
        return this.getTotalFilesCompleted(this.receivingFiles.values());
    }

    public long getTotalFilesSent() {
        return this.getTotalFilesCompleted(this.sendingFiles.values());
    }

    public long getTotalSizeReceived() {
        return this.getTotalSizeInProgress(this.receivingFiles.values());
    }

    public long getTotalSizeSent() {
        return this.getTotalSizeInProgress(this.sendingFiles.values());
    }

    public long getTotalFilesToReceive() {
        return this.getTotalFiles(this.receivingSummaries);
    }

    public long getTotalFilesToSend() {
        return this.getTotalFiles(this.sendingSummaries);
    }

    public long getTotalSizeToReceive() {
        return this.getTotalSizes(this.receivingSummaries);
    }

    public long getTotalSizeToSend() {
        return this.getTotalSizes(this.sendingSummaries);
    }

    private long getTotalSizeInProgress(Collection<ProgressInfo> streams) {
        long total = 0L;
        for (ProgressInfo stream : streams) {
            total += stream.currentBytes;
        }
        return total;
    }

    private long getTotalFiles(Collection<StreamSummary> summaries) {
        long total = 0L;
        for (StreamSummary summary : summaries) {
            total += (long)summary.files;
        }
        return total;
    }

    private long getTotalSizes(Collection<StreamSummary> summaries) {
        long total = 0L;
        for (StreamSummary summary : summaries) {
            total += summary.totalSize;
        }
        return total;
    }

    private long getTotalFilesCompleted(Collection<ProgressInfo> files) {
        Iterable completed = Iterables.filter(files, (Predicate)new Predicate<ProgressInfo>(){

            public boolean apply(ProgressInfo input) {
                return input.isCompleted();
            }
        });
        return Iterables.size((Iterable)completed);
    }

    public SessionSummary createSummary() {
        return new SessionSummary(FBUtilities.getBroadcastAddressAndPort(), this.peer, this.receivingSummaries, this.sendingSummaries);
    }

    public String getFailureReason() {
        return this.failureReason;
    }
}

