/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.tries;

import java.io.IOException;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.io.tries.IncrementalTrieWriter;
import org.apache.cassandra.io.tries.IncrementalTrieWriterBase;
import org.apache.cassandra.io.tries.TrieSerializer;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.io.util.DataOutputPlus;

@NotThreadSafe
public class IncrementalTrieWriterSimple<VALUE>
extends IncrementalTrieWriterBase<VALUE, DataOutputPlus, Node<VALUE>>
implements IncrementalTrieWriter<VALUE> {
    private long position = 0L;

    public IncrementalTrieWriterSimple(TrieSerializer<VALUE, ? super DataOutputPlus> trieSerializer, DataOutputPlus dest) {
        super(trieSerializer, dest, new Node(0));
    }

    @Override
    protected void complete(Node<VALUE> node) throws IOException {
        long nodePos = this.position;
        this.position += this.write(node, (DataOutputPlus)this.dest, this.position);
        node.finalizeWithPosition(nodePos);
    }

    @Override
    public void reset() {
        this.reset(new Node(0));
        this.position = 0L;
    }

    @Override
    public IncrementalTrieWriter.PartialTail makePartialRoot() throws IOException {
        try (DataOutputBuffer buf = new DataOutputBuffer();){
            IncrementalTrieWriterBase.PTail tail = new IncrementalTrieWriterBase.PTail();
            tail.cutoff = this.position;
            tail.count = this.count;
            long nodePos = this.position;
            for (Node node : this.stack::descendingIterator) {
                node.filePos = nodePos;
                nodePos += this.write(node, buf, nodePos);
            }
            tail.tail = buf.asNewBuffer();
            tail.root = ((Node)this.stack.getFirst()).filePos;
            for (Node node : this.stack::descendingIterator) {
                node.filePos = -1L;
            }
            IncrementalTrieWriterBase.PTail pTail = tail;
            return pTail;
        }
    }

    private long write(Node<VALUE> node, DataOutputPlus dest, long nodePosition) throws IOException {
        long size = this.serializer.sizeofNode(node, nodePosition);
        this.serializer.write(dest, node, nodePosition);
        return size;
    }

    static class Node<Value>
    extends IncrementalTrieWriterBase.BaseNode<Value, Node<Value>> {
        Node(int transition) {
            super(transition);
        }

        @Override
        Node<Value> newNode(byte transition) {
            return new Node<Value>(transition & 0xFF);
        }

        @Override
        public long serializedPositionDelta(int i, long nodePosition) {
            assert (((Node)this.children.get((int)i)).filePos != -1L);
            return ((Node)this.children.get((int)i)).filePos - nodePosition;
        }

        @Override
        public long maxPositionDelta(long nodePosition) {
            long min = 0L;
            for (Node child : this.children) {
                if (child.filePos == -1L) continue;
                min = Math.min(min, child.filePos - nodePosition);
            }
            return min;
        }
    }
}

