/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.tries;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.io.tries.IncrementalTrieWriterPageAware;
import org.apache.cassandra.io.tries.SerializationNode;
import org.apache.cassandra.io.tries.TrieSerializer;
import org.apache.cassandra.io.util.DataOutputPlus;

@NotThreadSafe
public class IncrementalDeepTrieWriterPageAware<VALUE>
extends IncrementalTrieWriterPageAware<VALUE> {
    private final int maxRecursionDepth;

    public IncrementalDeepTrieWriterPageAware(TrieSerializer<VALUE, ? super DataOutputPlus> trieSerializer, DataOutputPlus dest, int maxRecursionDepth) {
        super(trieSerializer, dest);
        this.maxRecursionDepth = maxRecursionDepth;
    }

    public IncrementalDeepTrieWriterPageAware(TrieSerializer<VALUE, ? super DataOutputPlus> trieSerializer, DataOutputPlus dest) {
        this(trieSerializer, dest, 64);
    }

    @Override
    protected int recalcTotalSize(IncrementalTrieWriterPageAware.Node<VALUE> node, long nodePosition) throws IOException {
        return this.recalcTotalSizeRecursiveOnStack(node, nodePosition, 0);
    }

    private int recalcTotalSizeRecursiveOnStack(IncrementalTrieWriterPageAware.Node<VALUE> node, long nodePosition, int depth) throws IOException {
        if (node.hasOutOfPageInBranch) {
            int sz = 0;
            for (IncrementalTrieWriterPageAware.Node child : node.children) {
                if (depth < this.maxRecursionDepth) {
                    sz += this.recalcTotalSizeRecursiveOnStack(child, nodePosition + (long)sz, depth + 1);
                    continue;
                }
                sz += this.recalcTotalSizeRecursiveOnHeap(child, nodePosition + (long)sz);
            }
            node.branchSize = sz;
        }
        if (node.hasOutOfPageChildren || node.hasOutOfPageInBranch) {
            node.nodeSize = this.serializer.sizeofNode(node, nodePosition + (long)node.branchSize);
        }
        return node.branchSize + node.nodeSize;
    }

    private int recalcTotalSizeRecursiveOnHeap(IncrementalTrieWriterPageAware.Node<VALUE> node, long nodePosition) throws IOException {
        if (node.hasOutOfPageInBranch) {
            new RecalcTotalSizeRecursion(node, null, nodePosition).process();
        }
        if (node.hasOutOfPageChildren || node.hasOutOfPageInBranch) {
            node.nodeSize = this.serializer.sizeofNode(node, nodePosition + (long)node.branchSize);
        }
        return node.branchSize + node.nodeSize;
    }

    @Override
    protected long write(IncrementalTrieWriterPageAware.Node<VALUE> node) throws IOException {
        return this.writeRecursiveOnStack(node, 0);
    }

    private long writeRecursiveOnStack(IncrementalTrieWriterPageAware.Node<VALUE> node, int depth) throws IOException {
        long nodePosition = ((DataOutputPlus)this.dest).position();
        for (IncrementalTrieWriterPageAware.Node child : node.children) {
            if (child.filePos != -1L) continue;
            if (depth < this.maxRecursionDepth) {
                child.filePos = this.writeRecursiveOnStack(child, depth + 1);
                continue;
            }
            child.filePos = this.writeRecursiveOnHeap(child);
        }
        assert (((DataOutputPlus)this.dest).position() == (nodePosition += (long)node.branchSize)) : "Expected node position to be " + nodePosition + " but got " + ((DataOutputPlus)this.dest).position() + " after writing children.\n" + this.dumpNode(node, ((DataOutputPlus)this.dest).position());
        this.serializer.write(this.dest, node, nodePosition);
        assert (((DataOutputPlus)this.dest).position() == nodePosition + (long)node.nodeSize || ((DataOutputPlus)this.dest).paddedPosition() == ((DataOutputPlus)this.dest).position()) : "Expected node position to be " + (nodePosition + (long)node.nodeSize) + " but got " + ((DataOutputPlus)this.dest).position() + " after writing node, nodeSize " + node.nodeSize + ".\n" + this.dumpNode(node, nodePosition);
        return nodePosition;
    }

    private long writeRecursiveOnHeap(IncrementalTrieWriterPageAware.Node<VALUE> node) throws IOException {
        return ((IncrementalTrieWriterPageAware.Node)(IncrementalDeepTrieWriterPageAware)this.new WriteRecursion(node, null).process().node).filePos;
    }

    @Override
    protected long writePartial(IncrementalTrieWriterPageAware.Node<VALUE> node, DataOutputPlus dest, long baseOffset) throws IOException {
        return this.writePartialRecursiveOnStack(node, dest, baseOffset, 0);
    }

    private long writePartialRecursiveOnStack(IncrementalTrieWriterPageAware.Node<VALUE> node, DataOutputPlus dest, long baseOffset, int depth) throws IOException {
        long startPosition = dest.position() + baseOffset;
        ArrayList<IncrementalTrieWriterPageAware.Node> childrenToClear = new ArrayList<IncrementalTrieWriterPageAware.Node>();
        for (IncrementalTrieWriterPageAware.Node child : node.children) {
            if (child.filePos != -1L) continue;
            childrenToClear.add(child);
            if (depth < this.maxRecursionDepth) {
                child.filePos = this.writePartialRecursiveOnStack(child, dest, baseOffset, depth + 1);
                continue;
            }
            child.filePos = this.writePartialRecursiveOnHeap(child, dest, baseOffset);
        }
        long nodePosition = dest.position() + baseOffset;
        if (node.hasOutOfPageInBranch) {
            node.branchSize = (int)(nodePosition - startPosition);
        }
        this.serializer.write(dest, node, nodePosition);
        if (node.hasOutOfPageChildren || node.hasOutOfPageInBranch) {
            long endPosition = dest.position() + baseOffset;
            node.nodeSize = (int)(endPosition - nodePosition);
        }
        for (IncrementalTrieWriterPageAware.Node child : childrenToClear) {
            child.filePos = -1L;
        }
        return nodePosition;
    }

    private long writePartialRecursiveOnHeap(IncrementalTrieWriterPageAware.Node<VALUE> node, DataOutputPlus dest, long baseOffset) throws IOException {
        new WritePartialRecursion(node, dest, baseOffset).process();
        long pos = node.filePos;
        node.filePos = -1L;
        return pos;
    }

    class WritePartialRecursion
    extends Recursion<IncrementalTrieWriterPageAware.Node<VALUE>> {
        final DataOutputPlus dest;
        final long baseOffset;
        final long startPosition;
        final List<IncrementalTrieWriterPageAware.Node<VALUE>> childrenToClear;

        WritePartialRecursion(IncrementalTrieWriterPageAware.Node<VALUE> node, WritePartialRecursion parent) {
            super(node, node.children.iterator(), parent);
            this.dest = parent.dest;
            this.baseOffset = parent.baseOffset;
            this.startPosition = this.dest.position() + this.baseOffset;
            this.childrenToClear = new ArrayList();
        }

        WritePartialRecursion(IncrementalTrieWriterPageAware.Node<VALUE> node, DataOutputPlus dest, long baseOffset) {
            super(node, node.children.iterator(), null);
            this.dest = dest;
            this.baseOffset = baseOffset;
            this.startPosition = dest.position() + baseOffset;
            this.childrenToClear = new ArrayList();
        }

        @Override
        Recursion<IncrementalTrieWriterPageAware.Node<VALUE>> makeChild(IncrementalTrieWriterPageAware.Node<VALUE> child) {
            if (child.filePos == -1L) {
                this.childrenToClear.add(child);
                return new WritePartialRecursion(child, this);
            }
            return null;
        }

        @Override
        void complete() throws IOException {
            long nodePosition = this.dest.position() + this.baseOffset;
            if (((IncrementalTrieWriterPageAware.Node)this.node).hasOutOfPageInBranch) {
                ((IncrementalTrieWriterPageAware.Node)this.node).branchSize = (int)(nodePosition - this.startPosition);
            }
            IncrementalDeepTrieWriterPageAware.this.serializer.write(this.dest, (SerializationNode)this.node, nodePosition);
            if (((IncrementalTrieWriterPageAware.Node)this.node).hasOutOfPageChildren || ((IncrementalTrieWriterPageAware.Node)this.node).hasOutOfPageInBranch) {
                long endPosition = this.dest.position() + this.baseOffset;
                ((IncrementalTrieWriterPageAware.Node)this.node).nodeSize = (int)(endPosition - nodePosition);
            }
            for (IncrementalTrieWriterPageAware.Node child : this.childrenToClear) {
                child.filePos = -1L;
            }
            ((IncrementalTrieWriterPageAware.Node)this.node).filePos = nodePosition;
        }
    }

    class WriteRecursion
    extends Recursion<IncrementalTrieWriterPageAware.Node<VALUE>> {
        long nodePosition;

        WriteRecursion(IncrementalTrieWriterPageAware.Node<VALUE> node, Recursion<IncrementalTrieWriterPageAware.Node<VALUE>> parent) {
            super(node, node.children.iterator(), parent);
            this.nodePosition = ((DataOutputPlus)IncrementalDeepTrieWriterPageAware.this.dest).position();
        }

        @Override
        Recursion<IncrementalTrieWriterPageAware.Node<VALUE>> makeChild(IncrementalTrieWriterPageAware.Node<VALUE> child) {
            if (child.filePos == -1L) {
                return new WriteRecursion(child, this);
            }
            return null;
        }

        @Override
        void complete() throws IOException {
            this.nodePosition += (long)((IncrementalTrieWriterPageAware.Node)this.node).branchSize;
            assert (((DataOutputPlus)IncrementalDeepTrieWriterPageAware.this.dest).position() == this.nodePosition) : "Expected node position to be " + this.nodePosition + " but got " + ((DataOutputPlus)IncrementalDeepTrieWriterPageAware.this.dest).position() + " after writing children.\n" + IncrementalDeepTrieWriterPageAware.this.dumpNode((IncrementalTrieWriterPageAware.Node)this.node, ((DataOutputPlus)IncrementalDeepTrieWriterPageAware.this.dest).position());
            IncrementalDeepTrieWriterPageAware.this.serializer.write(IncrementalDeepTrieWriterPageAware.this.dest, (SerializationNode)this.node, this.nodePosition);
            assert (((DataOutputPlus)IncrementalDeepTrieWriterPageAware.this.dest).position() == this.nodePosition + (long)((IncrementalTrieWriterPageAware.Node)this.node).nodeSize || ((DataOutputPlus)IncrementalDeepTrieWriterPageAware.this.dest).paddedPosition() == ((DataOutputPlus)IncrementalDeepTrieWriterPageAware.this.dest).position()) : "Expected node position to be " + (this.nodePosition + (long)((IncrementalTrieWriterPageAware.Node)this.node).nodeSize) + " but got " + ((DataOutputPlus)IncrementalDeepTrieWriterPageAware.this.dest).position() + " after writing node, nodeSize " + ((IncrementalTrieWriterPageAware.Node)this.node).nodeSize + ".\n" + IncrementalDeepTrieWriterPageAware.this.dumpNode((IncrementalTrieWriterPageAware.Node)this.node, this.nodePosition);
            ((IncrementalTrieWriterPageAware.Node)this.node).filePos = this.nodePosition;
        }
    }

    class RecalcTotalSizeRecursion
    extends Recursion<IncrementalTrieWriterPageAware.Node<VALUE>> {
        final long nodePosition;
        int sz;

        RecalcTotalSizeRecursion(IncrementalTrieWriterPageAware.Node<VALUE> node, Recursion<IncrementalTrieWriterPageAware.Node<VALUE>> parent, long nodePosition) {
            super(node, node.children.iterator(), parent);
            this.sz = 0;
            this.nodePosition = nodePosition;
        }

        @Override
        Recursion<IncrementalTrieWriterPageAware.Node<VALUE>> makeChild(IncrementalTrieWriterPageAware.Node<VALUE> child) {
            if (child.hasOutOfPageInBranch) {
                return new RecalcTotalSizeRecursion(child, this, this.nodePosition + (long)this.sz);
            }
            return null;
        }

        @Override
        void complete() {
            ((IncrementalTrieWriterPageAware.Node)this.node).branchSize = this.sz;
        }

        @Override
        void completeChild(IncrementalTrieWriterPageAware.Node<VALUE> child) {
            if (child.hasOutOfPageChildren || child.hasOutOfPageInBranch) {
                long childPosition = this.nodePosition + (long)this.sz;
                child.nodeSize = IncrementalDeepTrieWriterPageAware.this.serializer.sizeofNode(child, childPosition + (long)child.branchSize);
            }
            this.sz += child.branchSize + child.nodeSize;
        }
    }

    static abstract class Recursion<NODE> {
        final Recursion<NODE> parent;
        final NODE node;
        final Iterator<NODE> childIterator;

        Recursion(NODE node, Iterator<NODE> childIterator, Recursion<NODE> parent) {
            this.parent = parent;
            this.node = node;
            this.childIterator = childIterator;
        }

        abstract Recursion<NODE> makeChild(NODE var1);

        abstract void complete() throws IOException;

        void completeChild(NODE child) {
        }

        Recursion<NODE> process() throws IOException {
            Recursion<NODE> curr = this;
            while (true) {
                if (curr.childIterator.hasNext()) {
                    NODE child = curr.childIterator.next();
                    Recursion<NODE> childRec = curr.makeChild(child);
                    if (childRec != null) {
                        curr = childRec;
                        continue;
                    }
                    curr.completeChild(child);
                    continue;
                }
                curr.complete();
                Recursion<NODE> currParent = curr.parent;
                if (currParent == null) {
                    return curr;
                }
                currParent.completeChild(curr.node);
                curr = currParent;
            }
        }
    }
}

