/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import org.apache.cassandra.io.sstable.AbstractRowIndexEntry;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.tracing.Tracing;

public interface SSTableReadsListener {
    public static final SSTableReadsListener NOOP_LISTENER = new SSTableReadsListener(){};

    default public void onSSTableSkipped(SSTableReader sstable, SkippingReason reason) {
    }

    default public void onSSTableSelected(SSTableReader sstable, SelectionReason reason) {
    }

    default public void onScanningStarted(SSTableReader sstable) {
    }

    public static enum SelectionReason {
        KEY_CACHE_HIT("Key cache hit for sstable {}, size = {}"),
        INDEX_ENTRY_FOUND("Partition index found for sstable {}, size = {}");

        private final String message;

        private SelectionReason(String message) {
            this.message = message;
        }

        public void trace(Descriptor descriptor, AbstractRowIndexEntry entry) {
            Tracing.trace(this.message, (Object)descriptor.id, (Object)entry.blockCount());
        }
    }

    public static enum SkippingReason {
        BLOOM_FILTER("Bloom filter allows skipping sstable {}"),
        MIN_MAX_KEYS("Check against min and max keys allows skipping sstable {}"),
        PARTITION_INDEX_LOOKUP("Partition index lookup allows skipping sstable {}"),
        INDEX_ENTRY_NOT_FOUND("Partition index lookup complete (bloom filter false positive) for sstable {}");

        private final String message;

        private SkippingReason(String message) {
            this.message = message;
        }

        public void trace(Descriptor descriptor) {
            Tracing.trace(this.message, (Object)descriptor.id);
        }
    }
}

