/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sasi.disk;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.concurrent.ExecutorFactory;
import org.apache.cassandra.concurrent.ExecutorPlus;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.index.sasi.analyzer.AbstractAnalyzer;
import org.apache.cassandra.index.sasi.conf.ColumnIndex;
import org.apache.cassandra.index.sasi.disk.OnDiskIndex;
import org.apache.cassandra.index.sasi.disk.OnDiskIndexBuilder;
import org.apache.cassandra.index.sasi.utils.CombinedTermIterator;
import org.apache.cassandra.index.sasi.utils.TypeUtil;
import org.apache.cassandra.io.FSError;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTableFlushObserver;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.concurrent.CountDownLatch;
import org.apache.cassandra.utils.concurrent.ImmediateFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerSSTableIndexWriter
implements SSTableFlushObserver {
    private static final Logger logger = LoggerFactory.getLogger(PerSSTableIndexWriter.class);
    private static final int POOL_SIZE = 8;
    private static final ExecutorPlus INDEX_FLUSHER_MEMTABLE;
    private static final ExecutorPlus INDEX_FLUSHER_GENERAL;
    private final long nowInSec = FBUtilities.nowInSeconds();
    private final Descriptor descriptor;
    private final OperationType source;
    private final AbstractType<?> keyValidator;
    @VisibleForTesting
    protected final Map<ColumnMetadata, Index> indexes;
    private DecoratedKey currentKey;
    private long currentKeyPosition;
    private boolean isComplete;

    public PerSSTableIndexWriter(AbstractType<?> keyValidator, Descriptor descriptor, OperationType source, Map<ColumnMetadata, ColumnIndex> supportedIndexes) {
        this.keyValidator = keyValidator;
        this.descriptor = descriptor;
        this.source = source;
        this.indexes = Maps.newHashMapWithExpectedSize((int)supportedIndexes.size());
        for (Map.Entry<ColumnMetadata, ColumnIndex> entry : supportedIndexes.entrySet()) {
            this.indexes.put(entry.getKey(), this.newIndex(entry.getValue()));
        }
    }

    @Override
    public void begin() {
    }

    @Override
    public void startPartition(DecoratedKey key, long keyPosition, long KeyPositionForSASI) {
        this.currentKey = key;
        this.currentKeyPosition = KeyPositionForSASI;
    }

    @Override
    public void staticRow(Row staticRow) {
        this.nextUnfilteredCluster(staticRow);
    }

    @Override
    public void nextUnfilteredCluster(Unfiltered unfiltered) {
        if (!unfiltered.isRow()) {
            return;
        }
        Row row = (Row)unfiltered;
        this.indexes.forEach((column, index) -> {
            ByteBuffer value = ColumnIndex.getValueOf(column, row, this.nowInSec);
            if (value == null) {
                return;
            }
            if (index == null) {
                throw new IllegalArgumentException("No index exists for column " + column.name.toString());
            }
            index.add(value.duplicate(), this.currentKey, this.currentKeyPosition);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void complete() {
        if (this.isComplete) {
            return;
        }
        this.currentKey = null;
        try {
            CountDownLatch latch = CountDownLatch.newCountDownLatch(this.indexes.size());
            for (Index index : this.indexes.values()) {
                index.complete(latch);
            }
            latch.awaitUninterruptibly();
        }
        finally {
            this.indexes.clear();
            this.isComplete = true;
        }
    }

    public Index getIndex(ColumnMetadata columnDef) {
        return this.indexes.get(columnDef);
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    @VisibleForTesting
    protected Index newIndex(ColumnIndex columnIndex) {
        return new Index(columnIndex);
    }

    protected long maxMemorySize(ColumnIndex columnIndex) {
        return this.source == OperationType.FLUSH ? 0x40000000L : columnIndex.getMode().maxCompactionFlushMemoryInBytes;
    }

    public int hashCode() {
        return this.descriptor.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof PerSSTableIndexWriter && this.descriptor.equals(((PerSSTableIndexWriter)o).descriptor);
    }

    static {
        INDEX_FLUSHER_GENERAL = ExecutorFactory.Global.executorFactory().withJmxInternal().pooled("SASI-General", 8);
        INDEX_FLUSHER_MEMTABLE = ExecutorFactory.Global.executorFactory().withJmxInternal().pooled("SASI-Memtable", 8);
    }

    @VisibleForTesting
    protected class Index {
        @VisibleForTesting
        protected final File outputFile;
        private final ColumnIndex columnIndex;
        private final AbstractAnalyzer analyzer;
        private final long maxMemorySize;
        @VisibleForTesting
        protected final Set<Future<OnDiskIndex>> segments;
        private int segmentNumber = 0;
        private OnDiskIndexBuilder currentBuilder;

        public Index(ColumnIndex columnIndex) {
            this.columnIndex = columnIndex;
            this.outputFile = PerSSTableIndexWriter.this.descriptor.fileFor(columnIndex.getComponent());
            this.analyzer = columnIndex.getAnalyzer();
            this.segments = new HashSet<Future<OnDiskIndex>>();
            this.maxMemorySize = PerSSTableIndexWriter.this.maxMemorySize(columnIndex);
            this.currentBuilder = this.newIndexBuilder();
        }

        public void add(ByteBuffer term, DecoratedKey key, long keyPosition) {
            if (term.remaining() == 0) {
                return;
            }
            boolean isAdded = false;
            this.analyzer.reset(term);
            while (this.analyzer.hasNext()) {
                ByteBuffer token = this.analyzer.next();
                int size = token.remaining();
                if (token.remaining() >= 1024) {
                    logger.info("Rejecting value (size {}, maximum {}) for column {} (analyzed {}) at {} SSTable.", new Object[]{FBUtilities.prettyPrintMemory(term.remaining()), FBUtilities.prettyPrintMemory(1024L), this.columnIndex.getColumnName(), this.columnIndex.getMode().isAnalyzed, PerSSTableIndexWriter.this.descriptor});
                    continue;
                }
                if (!TypeUtil.isValid(token, this.columnIndex.getValidator()) && (token = TypeUtil.tryUpcast(token, this.columnIndex.getValidator())) == null) {
                    logger.info("({}) Failed to add {} to index for key: {}, value size was {}, validator is {}.", new Object[]{this.outputFile, this.columnIndex.getColumnName(), PerSSTableIndexWriter.this.keyValidator.getString(key.getKey()), FBUtilities.prettyPrintMemory(size), this.columnIndex.getValidator()});
                    continue;
                }
                this.currentBuilder.add(token, key, keyPosition);
                isAdded = true;
            }
            if (!isAdded || this.currentBuilder.estimatedMemoryUse() < this.maxMemorySize) {
                return;
            }
            this.segments.add(this.getExecutor().submit(this.scheduleSegmentFlush(false)));
        }

        @VisibleForTesting
        protected Callable<OnDiskIndex> scheduleSegmentFlush(boolean isFinal) {
            OnDiskIndexBuilder builder = this.currentBuilder;
            this.currentBuilder = this.newIndexBuilder();
            File segmentFile = this.file(isFinal);
            return () -> {
                long start = Clock.Global.nanoTime();
                try {
                    OnDiskIndex onDiskIndex = builder.finish(segmentFile) ? new OnDiskIndex(segmentFile, this.columnIndex.getValidator(), null) : null;
                    return onDiskIndex;
                }
                catch (Exception | FSError e) {
                    logger.error("Failed to build index segment {}", (Object)segmentFile, (Object)e);
                    OnDiskIndex onDiskIndex = null;
                    return onDiskIndex;
                }
                finally {
                    if (!isFinal) {
                        logger.info("Flushed index segment {}, took {} ms.", (Object)segmentFile, (Object)TimeUnit.NANOSECONDS.toMillis(Clock.Global.nanoTime() - start));
                    }
                }
            };
        }

        public void complete(CountDownLatch latch) {
            logger.info("Scheduling index flush to {}", (Object)this.outputFile);
            this.getExecutor().submit(() -> {
                long start1 = Clock.Global.nanoTime();
                OnDiskIndex[] parts = new OnDiskIndex[this.segments.size() + 1];
                try {
                    if (this.segments.isEmpty()) {
                        this.scheduleSegmentFlush(true).call();
                        return;
                    }
                    if (!this.currentBuilder.isEmpty()) {
                        OnDiskIndex last = this.scheduleSegmentFlush(false).call();
                        this.segments.add((Future<OnDiskIndex>)((Object)ImmediateFuture.success(last)));
                    }
                    int index = 0;
                    ByteBuffer combinedMin = null;
                    ByteBuffer combinedMax = null;
                    for (Future<OnDiskIndex> f : this.segments) {
                        OnDiskIndex part = f.get();
                        if (part == null) continue;
                        parts[index++] = part;
                        combinedMin = combinedMin == null || PerSSTableIndexWriter.this.keyValidator.compare(combinedMin, part.minKey()) > 0 ? part.minKey() : combinedMin;
                        combinedMax = combinedMax == null || PerSSTableIndexWriter.this.keyValidator.compare(combinedMax, part.maxKey()) < 0 ? part.maxKey() : combinedMax;
                    }
                    OnDiskIndexBuilder builder = this.newIndexBuilder();
                    builder.finish(Pair.create(combinedMin, combinedMax), this.outputFile, new CombinedTermIterator(parts));
                }
                catch (Exception | FSError e) {
                    logger.error("Failed to flush index {}.", (Object)this.outputFile, (Object)e);
                    this.outputFile.tryDelete();
                }
                finally {
                    logger.info("Index flush to {} took {} ms.", (Object)this.outputFile, (Object)TimeUnit.NANOSECONDS.toMillis(Clock.Global.nanoTime() - start1));
                    for (int segment = 0; segment < this.segmentNumber; ++segment) {
                        OnDiskIndex part = parts[segment];
                        if (part != null) {
                            FileUtils.closeQuietly(part);
                        }
                        this.outputFile.withSuffix("_" + segment).tryDelete();
                    }
                    latch.decrement();
                }
            });
        }

        private ExecutorService getExecutor() {
            return PerSSTableIndexWriter.this.source == OperationType.FLUSH ? INDEX_FLUSHER_MEMTABLE : INDEX_FLUSHER_GENERAL;
        }

        private OnDiskIndexBuilder newIndexBuilder() {
            return new OnDiskIndexBuilder(PerSSTableIndexWriter.this.keyValidator, this.columnIndex.getValidator(), this.columnIndex.getMode().mode);
        }

        public File file(boolean isFinal) {
            return isFinal ? this.outputFile : this.outputFile.withSuffix("_" + this.segmentNumber++);
        }
    }
}

