/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.plan;

import io.netty.util.concurrent.FastThreadLocal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ClusteringIndexNamesFilter;
import org.apache.cassandra.db.filter.ClusteringIndexSliceFilter;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.AbstractUnfilteredRowIterator;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.RequestTimeoutException;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.index.sai.QueryContext;
import org.apache.cassandra.index.sai.iterators.KeyRangeIterator;
import org.apache.cassandra.index.sai.metrics.TableQueryMetrics;
import org.apache.cassandra.index.sai.plan.FilterTree;
import org.apache.cassandra.index.sai.plan.Operation;
import org.apache.cassandra.index.sai.plan.QueryController;
import org.apache.cassandra.index.sai.plan.VectorTopKProcessor;
import org.apache.cassandra.index.sai.utils.PrimaryKey;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.AbstractIterator;
import org.apache.cassandra.utils.Clock;

public class StorageAttachedIndexSearcher
implements Index.Searcher {
    private static final int PARTITION_ROW_BATCH_SIZE = 100;
    private final ReadCommand command;
    private final QueryController queryController;
    private final QueryContext queryContext;
    private final TableQueryMetrics tableQueryMetrics;
    private static final FastThreadLocal<List<PrimaryKey>> nextKeys = new FastThreadLocal<List<PrimaryKey>>(){

        protected List<PrimaryKey> initialValue() {
            return new ArrayList<PrimaryKey>(100);
        }
    };

    public StorageAttachedIndexSearcher(ColumnFamilyStore cfs, TableQueryMetrics tableQueryMetrics, ReadCommand command, RowFilter indexFilter, long executionQuotaMs) {
        this.command = command;
        this.queryContext = new QueryContext(command, executionQuotaMs);
        this.queryController = new QueryController(cfs, command, indexFilter, this.queryContext);
        this.tableQueryMetrics = tableQueryMetrics;
    }

    @Override
    public ReadCommand command() {
        return this.command;
    }

    @Override
    public PartitionIterator filterReplicaFilteringProtection(PartitionIterator fullResponse) {
        for (RowFilter.Expression expression : this.queryController.indexFilter()) {
            if (!this.queryController.hasAnalyzer(expression)) continue;
            return StorageAttachedIndexSearcher.applyIndexFilter(fullResponse, Operation.buildFilter(this.queryController, true), this.queryContext);
        }
        return Index.Searcher.super.filterReplicaFilteringProtection(fullResponse);
    }

    @Override
    public UnfilteredPartitionIterator search(ReadExecutionController executionController) throws RequestTimeoutException {
        UnfilteredPartitionIterator topK;
        long currentShadowedKeysCount;
        long lastShadowedKeysCount;
        if (!this.command.isTopK()) {
            return new ResultRetriever(executionController, false);
        }
        Supplier<ResultRetriever> resultSupplier = () -> new ResultRetriever(executionController, true);
        do {
            lastShadowedKeysCount = this.queryContext.vectorContext().getShadowedPrimaryKeys().size();
            ResultRetriever result = resultSupplier.get();
            topK = (UnfilteredPartitionIterator)new VectorTopKProcessor(this.command).filter(result);
        } while (lastShadowedKeysCount != (currentShadowedKeysCount = (long)this.queryContext.vectorContext().getShadowedPrimaryKeys().size()));
        return topK;
    }

    private static PartitionIterator applyIndexFilter(final PartitionIterator response, final FilterTree tree, final QueryContext context) {
        return new PartitionIterator(){

            @Override
            public void close() {
                response.close();
            }

            @Override
            public boolean hasNext() {
                return response.hasNext();
            }

            @Override
            public RowIterator next() {
                final RowIterator delegate = (RowIterator)response.next();
                final Row staticRow = delegate.staticRow();
                if (!tree.restrictsNonStaticRow()) {
                    return tree.isSatisfiedBy(delegate.partitionKey(), staticRow, staticRow) ? delegate : null;
                }
                return new RowIterator(){
                    Row next;

                    @Override
                    public TableMetadata metadata() {
                        return delegate.metadata();
                    }

                    @Override
                    public boolean isReverseOrder() {
                        return delegate.isReverseOrder();
                    }

                    @Override
                    public RegularAndStaticColumns columns() {
                        return delegate.columns();
                    }

                    @Override
                    public DecoratedKey partitionKey() {
                        return delegate.partitionKey();
                    }

                    @Override
                    public Row staticRow() {
                        return staticRow;
                    }

                    @Override
                    public void close() {
                        delegate.close();
                    }

                    private Row computeNext() {
                        while (delegate.hasNext()) {
                            Row row = (Row)delegate.next();
                            ++context.rowsFiltered;
                            if (!tree.isSatisfiedBy(delegate.partitionKey(), row, staticRow)) continue;
                            return row;
                        }
                        return null;
                    }

                    private Row loadNext() {
                        if (this.next == null) {
                            this.next = this.computeNext();
                        }
                        return this.next;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.loadNext() != null;
                    }

                    @Override
                    public Row next() {
                        Row result = this.loadNext();
                        this.next = null;
                        if (result == null) {
                            throw new NoSuchElementException();
                        }
                        return result;
                    }
                };
            }
        };
    }

    private class ResultRetriever
    extends AbstractIterator<UnfilteredRowIterator>
    implements UnfilteredPartitionIterator {
        private final PrimaryKey firstPrimaryKey;
        private final PrimaryKey lastPrimaryKey;
        private final Iterator<DataRange> keyRanges;
        private final DataRange firstDataRange;
        private AbstractBounds<PartitionPosition> currentKeyRange;
        private final KeyRangeIterator resultKeyIterator;
        private final FilterTree filterTree;
        private final ReadExecutionController executionController;
        private final PrimaryKey.Factory keyFactory;
        private final boolean topK;
        private final int partitionRowBatchSize;
        private PrimaryKey lastKey;

        private ResultRetriever(ReadExecutionController executionController, boolean topK) {
            this.keyRanges = StorageAttachedIndexSearcher.this.queryController.dataRanges().iterator();
            this.firstDataRange = this.keyRanges.next();
            this.currentKeyRange = this.firstDataRange.keyRange();
            this.resultKeyIterator = Operation.buildIterator(StorageAttachedIndexSearcher.this.queryController);
            this.filterTree = Operation.buildFilter(StorageAttachedIndexSearcher.this.queryController, StorageAttachedIndexSearcher.this.queryController.usesStrictFiltering());
            this.executionController = executionController;
            this.keyFactory = StorageAttachedIndexSearcher.this.queryController.primaryKeyFactory();
            this.firstPrimaryKey = StorageAttachedIndexSearcher.this.queryController.firstPrimaryKeyInRange();
            this.lastPrimaryKey = StorageAttachedIndexSearcher.this.queryController.lastPrimaryKeyInRange();
            this.topK = topK;
            this.partitionRowBatchSize = Math.min(100, StorageAttachedIndexSearcher.this.command.limits().count());
        }

        @Override
        public UnfilteredRowIterator computeNext() {
            if (this.resultKeyIterator == null) {
                return (UnfilteredRowIterator)this.endOfData();
            }
            if (this.lastKey == null) {
                PrimaryKey skipTarget = this.firstPrimaryKey;
                ClusteringComparator comparator = StorageAttachedIndexSearcher.this.command.metadata().comparator;
                if (comparator.size() > 0 && !this.firstDataRange.selectsAllPartition() && !StorageAttachedIndexSearcher.this.command.rowFilter().hasStaticExpression() && ((PartitionPosition)this.currentKeyRange.left).equals(this.currentKeyRange.right) && this.currentKeyRange.left instanceof DecoratedKey) {
                    ClusteringIndexNamesFilter namesFilter;
                    DecoratedKey decoratedKey = (DecoratedKey)this.currentKeyRange.left;
                    ClusteringIndexFilter filter = this.firstDataRange.clusteringIndexFilter(decoratedKey);
                    if (filter instanceof ClusteringIndexSliceFilter) {
                        ByteBuffer[] rawValues;
                        ClusteringBound<?> startBound;
                        Slices slices = ((ClusteringIndexSliceFilter)filter).requestedSlices();
                        if (!slices.isEmpty() && !(startBound = slices.get(0).start()).isEmpty() && (rawValues = startBound.getBufferArray()).length == comparator.size()) {
                            skipTarget = this.keyFactory.create(decoratedKey, Clustering.make(rawValues));
                        }
                    } else if (filter instanceof ClusteringIndexNamesFilter && !(namesFilter = (ClusteringIndexNamesFilter)filter).requestedRows().isEmpty()) {
                        Clustering<?> skipClustering = namesFilter.requestedRows().iterator().next();
                        skipTarget = this.keyFactory.create(decoratedKey, skipClustering);
                    }
                }
                this.resultKeyIterator.skipTo(skipTarget);
            }
            this.skipToNextPartition();
            UnfilteredRowIterator iterator = this.nextRowIterator(this::nextSelectedKeysInRange);
            return iterator != null ? this.iteratePartition(iterator) : (UnfilteredRowIterator)this.endOfData();
        }

        @Nullable
        private UnfilteredRowIterator nextRowIterator(@Nonnull Supplier<List<PrimaryKey>> keysSupplier) {
            UnfilteredRowIterator iterator = null;
            while (iterator == null) {
                List<PrimaryKey> keys = keysSupplier.get();
                if (keys.isEmpty()) {
                    return null;
                }
                iterator = this.queryStorageAndFilter(keys);
            }
            return iterator;
        }

        private List<PrimaryKey> nextSelectedKeysInRange() {
            PrimaryKey firstKey;
            List threadLocalNextKeys = (List)nextKeys.get();
            threadLocalNextKeys.clear();
            do {
                if ((firstKey = this.nextKeyInRange()) != null) continue;
                return Collections.emptyList();
            } while (StorageAttachedIndexSearcher.this.queryController.doesNotSelect(firstKey) || firstKey.equals(this.lastKey, false));
            this.lastKey = firstKey;
            threadLocalNextKeys.add(firstKey);
            this.fillNextSelectedKeysInPartition(firstKey.partitionKey(), threadLocalNextKeys);
            return threadLocalNextKeys;
        }

        private List<PrimaryKey> nextSelectedKeysInPartition(DecoratedKey partitionKey) {
            List threadLocalNextKeys = (List)nextKeys.get();
            threadLocalNextKeys.clear();
            this.fillNextSelectedKeysInPartition(partitionKey, threadLocalNextKeys);
            return threadLocalNextKeys;
        }

        @Nullable
        private PrimaryKey nextKeyInRange() {
            PrimaryKey key = this.nextKey();
            while (key != null && !this.currentKeyRange.contains(key.partitionKey())) {
                if (!((PartitionPosition)this.currentKeyRange.right).isMinimum() && ((PartitionPosition)this.currentKeyRange.right).compareTo(key.partitionKey()) <= 0) {
                    this.currentKeyRange = this.nextKeyRange();
                    if (this.currentKeyRange != null) continue;
                    return null;
                }
                this.skipTo(((PartitionPosition)this.currentKeyRange.left).getToken());
                key = this.nextKey();
            }
            return key;
        }

        private void fillNextSelectedKeysInPartition(DecoratedKey partitionKey, List<PrimaryKey> nextPrimaryKeys) {
            PrimaryKey key;
            while (this.resultKeyIterator.hasNext() && ((PrimaryKey)this.resultKeyIterator.peek()).partitionKey().equals(partitionKey) && nextPrimaryKeys.size() < this.partitionRowBatchSize && (key = this.nextKey()) != null) {
                if (StorageAttachedIndexSearcher.this.queryController.doesNotSelect(key) || key.equals(this.lastKey, false)) continue;
                nextPrimaryKeys.add(key);
                this.lastKey = key;
            }
        }

        @Nullable
        private PrimaryKey nextKey() {
            if (!this.resultKeyIterator.hasNext()) {
                return null;
            }
            PrimaryKey key = (PrimaryKey)this.resultKeyIterator.next();
            return this.isWithinUpperBound(key) ? key : null;
        }

        private boolean isWithinUpperBound(PrimaryKey key) {
            return this.lastPrimaryKey.token().isMinimum() || this.lastPrimaryKey.compareTo(key, false) >= 0;
        }

        @Nullable
        private AbstractBounds<PartitionPosition> nextKeyRange() {
            return this.keyRanges.hasNext() ? this.keyRanges.next().keyRange() : null;
        }

        private void skipTo(@Nonnull Token token) {
            this.resultKeyIterator.skipTo(this.keyFactory.create(token));
        }

        private void skipToNextPartition() {
            if (this.lastKey == null) {
                return;
            }
            DecoratedKey lastPartitionKey = this.lastKey.partitionKey();
            while (this.resultKeyIterator.hasNext() && ((PrimaryKey)this.resultKeyIterator.peek()).partitionKey().equals(lastPartitionKey)) {
                this.resultKeyIterator.next();
            }
        }

        @Nonnull
        private UnfilteredRowIterator iteratePartition(final @Nonnull UnfilteredRowIterator startIter) {
            return new AbstractUnfilteredRowIterator(startIter.metadata(), startIter.partitionKey(), startIter.partitionLevelDeletion(), startIter.columns(), startIter.staticRow(), startIter.isReverseOrder(), startIter.stats()){
                private UnfilteredRowIterator currentIter;
                private final DecoratedKey partitionKey;
                {
                    super(metadata, partitionKey, partitionLevelDeletion, columns, staticRow, isReverseOrder, stats);
                    this.currentIter = startIter;
                    this.partitionKey = startIter.partitionKey();
                }

                @Override
                protected Unfiltered computeNext() {
                    while (!this.currentIter.hasNext()) {
                        this.currentIter.close();
                        this.currentIter = ResultRetriever.this.nextRowIterator(() -> ResultRetriever.this.nextSelectedKeysInPartition(this.partitionKey));
                        if (this.currentIter != null) continue;
                        return (Unfiltered)this.endOfData();
                    }
                    return (Unfiltered)this.currentIter.next();
                }

                @Override
                public void close() {
                    FileUtils.closeQuietly(this.currentIter);
                    super.close();
                }
            };
        }

        private UnfilteredRowIterator queryStorageAndFilter(List<PrimaryKey> keys) {
            long startTimeNanos = Clock.Global.nanoTime();
            try (UnfilteredRowIterator partition = StorageAttachedIndexSearcher.this.queryController.queryStorage(keys, this.executionController);){
                ++StorageAttachedIndexSearcher.this.queryContext.partitionsRead;
                StorageAttachedIndexSearcher.this.queryContext.checkpoint();
                UnfilteredRowIterator filtered = this.filterPartition(keys, partition, this.filterTree);
                StorageAttachedIndexSearcher.this.tableQueryMetrics.postFilteringReadLatency.update(Clock.Global.nanoTime() - startTimeNanos, TimeUnit.NANOSECONDS);
                UnfilteredRowIterator unfilteredRowIterator = filtered;
                return unfilteredRowIterator;
            }
        }

        private UnfilteredRowIterator filterPartition(List<PrimaryKey> keys, UnfilteredRowIterator partition, FilterTree tree) {
            HashSet<PrimaryKey> keysToShadow;
            Row staticRow = partition.staticRow();
            DecoratedKey partitionKey = partition.partitionKey();
            ArrayList<Unfiltered> matches = new ArrayList<Unfiltered>();
            boolean hasMatch = false;
            HashSet<PrimaryKey> hashSet = keysToShadow = this.topK ? new HashSet<PrimaryKey>(keys) : Collections.emptySet();
            while (partition.hasNext()) {
                Unfiltered unfiltered = (Unfiltered)partition.next();
                if (!unfiltered.isRow()) continue;
                ++StorageAttachedIndexSearcher.this.queryContext.rowsFiltered;
                if (!tree.isSatisfiedBy(partitionKey, (Row)unfiltered, staticRow)) continue;
                matches.add(unfiltered);
                hasMatch = true;
                if (!this.topK) continue;
                PrimaryKey shadowed = this.keyFactory.hasClusteringColumns() ? this.keyFactory.create(partitionKey, (Clustering<?>)((Row)unfiltered).clustering()) : this.keyFactory.create(partitionKey);
                keysToShadow.remove(shadowed);
            }
            if (this.topK && hasMatch && this.keyFactory.hasClusteringColumns()) {
                keysToShadow.remove(this.keyFactory.create(partitionKey, Clustering.STATIC_CLUSTERING));
            }
            if (!hasMatch) {
                ++StorageAttachedIndexSearcher.this.queryContext.rowsFiltered;
                if (tree.isSatisfiedBy(partitionKey, staticRow, staticRow)) {
                    hasMatch = true;
                    if (this.topK) {
                        keysToShadow.clear();
                    }
                }
            }
            if (this.topK && !keysToShadow.isEmpty()) {
                StorageAttachedIndexSearcher.this.queryContext.vectorContext().recordShadowedPrimaryKeys(keysToShadow);
            }
            if (!hasMatch) {
                return null;
            }
            return new PartitionIterator(partition, staticRow, matches.iterator());
        }

        @Override
        public TableMetadata metadata() {
            return StorageAttachedIndexSearcher.this.queryController.metadata();
        }

        @Override
        public void close() {
            FileUtils.closeQuietly(this.resultKeyIterator);
            if (StorageAttachedIndexSearcher.this.tableQueryMetrics != null) {
                StorageAttachedIndexSearcher.this.tableQueryMetrics.record(StorageAttachedIndexSearcher.this.queryContext);
            }
        }

        private class PartitionIterator
        extends AbstractUnfilteredRowIterator {
            private final Iterator<Unfiltered> rows;

            public PartitionIterator(UnfilteredRowIterator partition, Row staticRow, Iterator<Unfiltered> rows) {
                super(partition.metadata(), partition.partitionKey(), partition.partitionLevelDeletion(), partition.columns(), staticRow, partition.isReverseOrder(), partition.stats());
                this.rows = rows;
            }

            @Override
            protected Unfiltered computeNext() {
                return this.rows.hasNext() ? this.rows.next() : (Unfiltered)this.endOfData();
            }
        }
    }
}

