/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.index.SecondaryIndexBuilder;
import org.apache.cassandra.index.sai.StorageAttachedIndex;
import org.apache.cassandra.index.sai.StorageAttachedIndexBuilder;
import org.apache.cassandra.index.sai.StorageAttachedIndexGroup;
import org.apache.cassandra.index.sai.disk.format.IndexDescriptor;
import org.apache.cassandra.io.sstable.SSTableIdFactory;
import org.apache.cassandra.io.sstable.format.SSTableReader;

class StorageAttachedIndexBuildingSupport
implements Index.IndexBuildingSupport {
    StorageAttachedIndexBuildingSupport() {
    }

    @Override
    public SecondaryIndexBuilder getIndexBuildTask(ColumnFamilyStore cfs, Set<Index> indexes, Collection<SSTableReader> sstablesToRebuild, boolean isFullRebuild) {
        TreeMap<SSTableReader, Set<StorageAttachedIndex>> sstables = new TreeMap<SSTableReader, Set<StorageAttachedIndex>>(Comparator.comparing(s -> s.descriptor.id, SSTableIdFactory.COMPARATOR));
        StorageAttachedIndexGroup group = StorageAttachedIndexGroup.getIndexGroup(cfs);
        assert (group != null) : "Index group does not exist for table " + cfs.keyspace + "." + cfs.name;
        indexes.stream().filter(i -> i instanceof StorageAttachedIndex).forEach(i -> {
            StorageAttachedIndex sai = (StorageAttachedIndex)i;
            Collection ss = sstablesToRebuild;
            if (!isFullRebuild) {
                ss = sstablesToRebuild.stream().filter(s -> !IndexDescriptor.create(s).isPerColumnIndexBuildComplete(sai.identifier())).collect(Collectors.toList());
            }
            group.dropIndexSSTables(ss, sai);
            ss.forEach(sstable -> sstables.computeIfAbsent((SSTableReader)sstable, ignore -> new HashSet()).add(sai));
        });
        return new StorageAttachedIndexBuilder(group, sstables, isFullRebuild, false);
    }
}

