/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.virtual;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.virtual.VirtualKeyspaceRegistry;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.service.ClientState;

public final class VirtualMutation
implements IMutation {
    private final String keyspaceName;
    private final DecoratedKey partitionKey;
    private final ImmutableMap<TableId, PartitionUpdate> modifications;

    public VirtualMutation(PartitionUpdate update) {
        this(update.metadata().keyspace, update.partitionKey(), (ImmutableMap<TableId, PartitionUpdate>)ImmutableMap.of((Object)update.metadata().id, (Object)update));
    }

    public VirtualMutation(String keyspaceName, DecoratedKey partitionKey, ImmutableMap<TableId, PartitionUpdate> modifications) {
        this.keyspaceName = keyspaceName;
        this.partitionKey = partitionKey;
        this.modifications = modifications;
    }

    @Override
    public void apply() {
        this.modifications.forEach((id, update) -> VirtualKeyspaceRegistry.instance.getTableNullable((TableId)id).apply((PartitionUpdate)update));
    }

    @Override
    public String getKeyspaceName() {
        return this.keyspaceName;
    }

    @Override
    public Collection<TableId> getTableIds() {
        return this.modifications.keySet();
    }

    @Override
    public DecoratedKey key() {
        return this.partitionKey;
    }

    @Override
    public long getTimeout(TimeUnit unit) {
        return DatabaseDescriptor.getWriteRpcTimeout(unit);
    }

    @Override
    public String toString(boolean shallow) {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this).add("keyspace", (Object)this.keyspaceName).add("partition key", (Object)this.partitionKey);
        if (shallow) {
            helper.add("tables", this.getTableIds());
        } else {
            helper.add("modifications", this.getPartitionUpdates());
        }
        return helper.toString();
    }

    @Override
    public Collection<PartitionUpdate> getPartitionUpdates() {
        return this.modifications.values();
    }

    @Override
    public Supplier<Mutation> hintOnFailure() {
        return null;
    }

    @Override
    public void validateIndexedColumns(ClientState state) {
    }

    @Override
    public void validateSize(int version, int overhead) {
    }
}

