/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.tries;

import java.util.function.BiConsumer;
import org.apache.cassandra.db.tries.Trie;
import org.apache.cassandra.db.tries.TriePathReconstructor;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;

public abstract class TrieEntriesWalker<T, V>
extends TriePathReconstructor
implements Trie.Walker<T, V> {
    @Override
    public void content(T content) {
        this.content(content, this.keyBytes, this.keyPos);
    }

    protected abstract void content(T var1, byte[] var2, int var3);

    static class WithConsumer<T>
    extends TrieEntriesWalker<T, Void> {
        private final BiConsumer<ByteComparable, T> consumer;

        public WithConsumer(BiConsumer<ByteComparable, T> consumer) {
            this.consumer = consumer;
        }

        @Override
        protected void content(T content, byte[] bytes, int byteLength) {
            this.consumer.accept(WithConsumer.toByteComparable(bytes, byteLength), (ByteComparable)content);
        }

        @Override
        public Void complete() {
            return null;
        }
    }
}

