/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.lifecycle;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.utils.Interval;
import org.apache.cassandra.utils.IntervalTree;

public class SSTableIntervalTree
extends IntervalTree<PartitionPosition, SSTableReader, Interval<PartitionPosition, SSTableReader>> {
    private static final SSTableIntervalTree EMPTY = new SSTableIntervalTree(null);

    SSTableIntervalTree(Collection<Interval<PartitionPosition, SSTableReader>> intervals) {
        super(intervals);
    }

    private SSTableIntervalTree(Interval<PartitionPosition, SSTableReader>[] minOrder, Interval<PartitionPosition, SSTableReader>[] maxOrder) {
        super((Interval[])minOrder, (Interval[])maxOrder);
    }

    protected SSTableIntervalTree create(Interval<PartitionPosition, SSTableReader>[] minOrder, Interval<PartitionPosition, SSTableReader>[] maxOrder) {
        return new SSTableIntervalTree(minOrder, maxOrder);
    }

    public static SSTableIntervalTree empty() {
        return EMPTY;
    }

    public static SSTableIntervalTree buildSSTableIntervalTree(Collection<SSTableReader> sstables) {
        if (sstables.isEmpty()) {
            return EMPTY;
        }
        return new SSTableIntervalTree((Collection<Interval<PartitionPosition, SSTableReader>>)SSTableIntervalTree.buildIntervals(sstables));
    }

    public static List<Interval<PartitionPosition, SSTableReader>> buildIntervals(Collection<SSTableReader> sstables) {
        if (sstables == null || sstables.isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(SSTableIntervalTree.buildIntervalsArray(sstables));
    }

    public static Interval<PartitionPosition, SSTableReader>[] buildIntervalsArray(Collection<SSTableReader> sstables) {
        if (sstables == null || sstables.isEmpty()) {
            return IntervalTree.EMPTY_ARRAY;
        }
        Interval[] intervals = new Interval[sstables.size()];
        int i = 0;
        int missingIntervals = 0;
        for (SSTableReader sstable : sstables) {
            Interval<PartitionPosition, SSTableReader> interval = sstable.getInterval();
            if (interval == null) {
                ++missingIntervals;
                continue;
            }
            intervals[i++] = interval;
        }
        if (missingIntervals > 0) {
            Preconditions.checkState((boolean)DatabaseDescriptor.isToolInitialized(), (Object)"Can only safely build an interval tree on sstables with missing first and last for offline tools");
            Interval[] replacementIntervals = new Interval[intervals.length - missingIntervals];
            System.arraycopy(intervals, 0, replacementIntervals, 0, replacementIntervals.length);
            return replacementIntervals;
        }
        return intervals;
    }

    public static SSTableIntervalTree update(SSTableIntervalTree tree, Collection<SSTableReader> removals, Collection<SSTableReader> additions) {
        return (SSTableIntervalTree)tree.update(SSTableIntervalTree.buildIntervalsArray(removals), SSTableIntervalTree.buildIntervalsArray(additions));
    }
}

