/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.selection;

import com.google.common.base.Objects;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.FieldIdentifier;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.UserTypes;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.selection.SelectionColumnMapping;
import org.apache.cassandra.cql3.selection.Selector;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.TupleType;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;

final class UserTypeSelector
extends Selector {
    protected static final Selector.SelectorDeserializer deserializer = new Selector.SelectorDeserializer(){

        @Override
        protected Selector deserialize(DataInputPlus in, int version, TableMetadata metadata) throws IOException {
            UserType type = (UserType)this.readType(metadata, in);
            int size = in.readUnsignedVInt32();
            HashMap<FieldIdentifier, Selector> fields = new HashMap<FieldIdentifier, Selector>(size);
            for (int i = 0; i < size; ++i) {
                FieldIdentifier identifier = new FieldIdentifier(ByteBufferUtil.readWithVIntLength(in));
                Selector selector = Selector.serializer.deserialize(in, version, metadata);
                fields.put(identifier, selector);
            }
            return new UserTypeSelector(type, fields);
        }
    };
    private final AbstractType<?> type;
    private final Map<FieldIdentifier, Selector> fields;

    public static Selector.Factory newFactory(final AbstractType<?> type, final Map<FieldIdentifier, Selector.Factory> factories) {
        return new Selector.Factory(){

            @Override
            protected String getColumnName() {
                return UserTypes.userTypeToString(factories, Selector.Factory::getColumnName);
            }

            @Override
            protected AbstractType<?> getReturnType() {
                return type;
            }

            @Override
            protected final void addColumnMapping(SelectionColumnMapping mapping, ColumnSpecification resultsColumn) {
                SelectionColumnMapping tmpMapping = SelectionColumnMapping.newMapping();
                for (Selector.Factory factory : factories.values()) {
                    factory.addColumnMapping(tmpMapping, resultsColumn);
                }
                if (tmpMapping.getMappings().get((Object)resultsColumn).isEmpty()) {
                    mapping.addMapping(resultsColumn, (ColumnMetadata)null);
                } else {
                    mapping.addMapping(resultsColumn, tmpMapping.getMappings().values());
                }
            }

            @Override
            public Selector newInstance(QueryOptions options) {
                HashMap<FieldIdentifier, Selector> fields = new HashMap<FieldIdentifier, Selector>(factories.size());
                for (Map.Entry factory : factories.entrySet()) {
                    fields.put((FieldIdentifier)factory.getKey(), ((Selector.Factory)factory.getValue()).newInstance(options));
                }
                return new UserTypeSelector(type, fields);
            }

            @Override
            public boolean isAggregateSelectorFactory() {
                for (Selector.Factory factory : factories.values()) {
                    if (!factory.isAggregateSelectorFactory()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void addFunctionsTo(List<Function> functions) {
                for (Selector.Factory factory : factories.values()) {
                    factory.addFunctionsTo(functions);
                }
            }

            @Override
            public boolean isWritetimeSelectorFactory() {
                for (Selector.Factory factory : factories.values()) {
                    if (!factory.isWritetimeSelectorFactory()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean isTTLSelectorFactory() {
                for (Selector.Factory factory : factories.values()) {
                    if (!factory.isTTLSelectorFactory()) continue;
                    return true;
                }
                return false;
            }

            @Override
            boolean areAllFetchedColumnsKnown() {
                for (Selector.Factory factory : factories.values()) {
                    if (factory.areAllFetchedColumnsKnown()) continue;
                    return false;
                }
                return true;
            }

            @Override
            void addFetchedColumns(ColumnFilter.Builder builder) {
                for (Selector.Factory factory : factories.values()) {
                    factory.addFetchedColumns(builder);
                }
            }
        };
    }

    @Override
    public void addFetchedColumns(ColumnFilter.Builder builder) {
        for (Selector field : this.fields.values()) {
            field.addFetchedColumns(builder);
        }
    }

    @Override
    public void addInput(Selector.InputRow input) {
        for (Selector field : this.fields.values()) {
            field.addInput(input);
        }
    }

    @Override
    public ByteBuffer getOutput(ProtocolVersion protocolVersion) {
        UserType userType = (UserType)this.type;
        ByteBuffer[] buffers = new ByteBuffer[userType.size()];
        int m = userType.size();
        for (int i = 0; i < m; ++i) {
            Selector selector = this.fields.get(userType.fieldName(i));
            if (selector == null) continue;
            buffers[i] = selector.getOutput(protocolVersion);
        }
        return TupleType.buildValue(buffers);
    }

    @Override
    public void reset() {
        for (Selector field : this.fields.values()) {
            field.reset();
        }
    }

    @Override
    public boolean isTerminal() {
        for (Selector field : this.fields.values()) {
            if (field.isTerminal()) continue;
            return false;
        }
        return true;
    }

    @Override
    public AbstractType<?> getType() {
        return this.type;
    }

    public String toString() {
        return UserTypes.userTypeToString(this.fields);
    }

    private UserTypeSelector(AbstractType<?> type, Map<FieldIdentifier, Selector> fields) {
        super(Selector.Kind.USER_TYPE_SELECTOR);
        this.type = type;
        this.fields = fields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserTypeSelector)) {
            return false;
        }
        UserTypeSelector s = (UserTypeSelector)o;
        return Objects.equal(this.type, s.type) && Objects.equal(this.fields, s.fields);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type, this.fields});
    }

    @Override
    protected int serializedSize(int version) {
        int size = UserTypeSelector.sizeOf(this.type) + TypeSizes.sizeofUnsignedVInt(this.fields.size());
        for (Map.Entry<FieldIdentifier, Selector> field : this.fields.entrySet()) {
            size += ByteBufferUtil.serializedSizeWithVIntLength(field.getKey().bytes) + serializer.serializedSize(field.getValue(), version);
        }
        return size;
    }

    @Override
    protected void serialize(DataOutputPlus out, int version) throws IOException {
        UserTypeSelector.writeType(out, this.type);
        out.writeUnsignedVInt32(this.fields.size());
        for (Map.Entry<FieldIdentifier, Selector> field : this.fields.entrySet()) {
            ByteBufferUtil.writeWithVIntLength(field.getKey().bytes, out);
            serializer.serialize(field.getValue(), out, version);
        }
    }
}

