/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.cql3.functions.Arguments;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.NativeScalarFunction;
import org.apache.cassandra.cql3.functions.PartialScalarFunction;
import org.apache.cassandra.cql3.functions.ScalarFunction;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.transport.ProtocolVersion;

class PreComputedScalarFunction
extends NativeScalarFunction
implements PartialScalarFunction {
    private final ByteBuffer value;
    private final ProtocolVersion valueVersion;
    private final ScalarFunction function;
    private final List<ByteBuffer> arguments;

    PreComputedScalarFunction(AbstractType<?> returnType, ByteBuffer value, ProtocolVersion valueVersion, ScalarFunction function, List<ByteBuffer> arguments) {
        super("__constant__", returnType, new AbstractType[0]);
        this.value = value;
        this.valueVersion = valueVersion;
        this.function = function;
        this.arguments = arguments;
    }

    @Override
    public Function getFunction() {
        return this.function;
    }

    @Override
    public List<ByteBuffer> getPartialArguments() {
        return this.arguments;
    }

    @Override
    public ByteBuffer execute(Arguments nothing) throws InvalidRequestException {
        if (nothing.getProtocolVersion() == this.valueVersion) {
            return this.value;
        }
        Arguments args = this.function.newArguments(nothing.getProtocolVersion());
        int m = this.arguments.size();
        for (int i = 0; i < m; ++i) {
            args.set(i, this.arguments.get(i));
        }
        return this.function.execute(args);
    }

    @Override
    public ScalarFunction partialApplication(ProtocolVersion protocolVersion, List<ByteBuffer> nothing) throws InvalidRequestException {
        return this;
    }
}

