/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import org.apache.cassandra.auth.AuthCache;
import org.apache.cassandra.auth.DCPermissions;
import org.apache.cassandra.auth.INetworkAuthorizer;
import org.apache.cassandra.auth.NetworkPermissionsCacheMBean;
import org.apache.cassandra.auth.RoleResource;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.utils.MBeanWrapper;

public class NetworkPermissionsCache
extends AuthCache<RoleResource, DCPermissions>
implements NetworkPermissionsCacheMBean {
    public NetworkPermissionsCache(INetworkAuthorizer authorizer) {
        super("NetworkPermissionsCache", DatabaseDescriptor::setRolesValidity, DatabaseDescriptor::getRolesValidity, DatabaseDescriptor::setRolesUpdateInterval, DatabaseDescriptor::getRolesUpdateInterval, DatabaseDescriptor::setRolesCacheMaxEntries, DatabaseDescriptor::getRolesCacheMaxEntries, DatabaseDescriptor::setRolesCacheActiveUpdate, DatabaseDescriptor::getRolesCacheActiveUpdate, authorizer::authorize, authorizer.bulkLoader(), () -> DatabaseDescriptor.getAuthenticator().requireAuthentication());
        MBeanWrapper.instance.registerMBean((Object)this, "org.apache.cassandra.auth:type=NetworkAuthCache");
    }

    @Override
    public void invalidateNetworkPermissions(String roleName) {
        this.invalidate(RoleResource.role(roleName));
    }

    @Override
    protected void unregisterMBean() {
        super.unregisterMBean();
        MBeanWrapper.instance.unregisterMBean("org.apache.cassandra.auth:type=NetworkAuthCache", MBeanWrapper.OnException.LOG);
    }
}

