/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.DebugFlag;
import com.amazon.corretto.crypto.provider.Janitor;
import com.amazon.corretto.crypto.provider.Loader;
import com.amazon.corretto.crypto.provider.MiscInterfaces;
import com.amazon.corretto.crypto.provider.RuntimeCryptoException;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.LongConsumer;

class NativeResource {
    private final Cell cell;
    private final Janitor.Mess mess;

    private static void wakeCleaner() {
        Loader.RESOURCE_JANITOR.wake();
    }

    protected NativeResource(long l, LongConsumer longConsumer) {
        this(l, longConsumer, false);
    }

    protected NativeResource(long l, LongConsumer longConsumer, boolean bl) {
        this.cell = new Cell(l, longConsumer, bl);
        this.mess = Loader.RESOURCE_JANITOR.register(this, this.cell::release);
    }

    boolean isReleased() {
        return this.cell.isReleased();
    }

    public <T, X extends Throwable> T use(MiscInterfaces.ThrowingLongFunction<T, X> throwingLongFunction) throws X {
        return this.cell.use(throwingLongFunction);
    }

    public <X extends Throwable> void useVoid(MiscInterfaces.ThrowingLongConsumer<X> throwingLongConsumer) throws X {
        Object object = this.cell.use(l -> {
            throwingLongConsumer.accept(l);
            return null;
        });
    }

    long take() {
        long l = this.cell.take();
        this.mess.clean();
        return l;
    }

    void release() {
        this.mess.clean();
    }

    private static final class CloseableLock
    implements AutoCloseable {
        private final Lock lock;

        CloseableLock(Lock lock) {
            this.lock = lock;
            this.lock.lock();
        }

        @Override
        public void close() {
            this.lock.unlock();
        }
    }

    private static final class Cell
    extends ReentrantReadWriteLock {
        private static final long serialVersionUID = 1L;
        private static final boolean FREE_TRACE_DEBUG = DebugFlag.FREETRACE.isEnabled();
        private Throwable creationTrace;
        private Throwable freeTrace;
        private final long ptr;
        private final LongConsumer releaser;
        private final boolean isThreadSafe;
        private boolean released;

        private Cell(long l, LongConsumer longConsumer, boolean bl) {
            if (l == 0L) {
                throw new AssertionError((Object)"ptr must not be equal to zero");
            }
            this.ptr = l;
            this.releaser = longConsumer;
            this.released = false;
            this.isThreadSafe = bl;
            this.creationTrace = Cell.buildFreeTrace("Created", null);
        }

        private CloseableLock getLock(boolean bl) {
            if (!this.isThreadSafe || bl) {
                return new CloseableLock(this.writeLock());
            }
            return new CloseableLock(this.readLock());
        }

        public void release() {
            try (CloseableLock closeableLock = this.getLock(true);){
                if (this.released) {
                    return;
                }
                this.released = true;
                this.freeTrace = Cell.buildFreeTrace("Freed", this.creationTrace);
                this.releaser.accept(this.ptr);
            }
        }

        public long take() {
            try (CloseableLock closeableLock = this.getLock(true);){
                this.assertNotFreed();
                this.released = true;
                this.freeTrace = Cell.buildFreeTrace("Freed", this.creationTrace);
                long l = this.ptr;
                return l;
            }
        }

        public boolean isReleased() {
            try (CloseableLock closeableLock = this.getLock(true);){
                boolean bl = this.released;
                return bl;
            }
        }

        public <T, X extends Throwable> T use(MiscInterfaces.ThrowingLongFunction<T, X> throwingLongFunction) throws X {
            try (CloseableLock closeableLock = this.getLock(false);){
                this.assertNotFreed();
                T t = throwingLongFunction.apply(this.ptr);
                return t;
            }
        }

        private void assertNotFreed() {
            if (this.released) {
                throw new IllegalStateException("Use after free", this.freeTrace);
            }
        }

        private static Throwable buildFreeTrace(String string, Throwable throwable) {
            if (!FREE_TRACE_DEBUG) {
                return null;
            }
            return new RuntimeCryptoException(string + " in Thread " + Thread.currentThread().getName(), throwable);
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            throw new NotSerializableException("NativeResource");
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            throw new NotSerializableException("NativeResource");
        }

        private void readObjectNoData() throws ObjectStreamException {
            throw new NotSerializableException("NativeResource");
        }
    }
}

