/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.AccessibleByteArrayOutputStream;
import com.amazon.corretto.crypto.provider.AmazonCorrettoCryptoProvider;
import com.amazon.corretto.crypto.provider.EvpKeyType;
import com.amazon.corretto.crypto.provider.EvpSignatureBase;
import java.nio.ByteBuffer;
import java.security.SignatureException;

class EvpSignatureRaw
extends EvpSignatureBase {
    private AccessibleByteArrayOutputStream buffer = new AccessibleByteArrayOutputStream(64, 0x100000);

    private EvpSignatureRaw(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider, EvpKeyType evpKeyType, int n) {
        super(amazonCorrettoCryptoProvider, evpKeyType, n, 0L);
    }

    @Override
    protected void engineReset() {
        this.buffer.reset();
    }

    @Override
    protected void engineUpdate(byte by) throws SignatureException {
        this.buffer.write(by & 0xFF);
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.buffer.write(byArray, n, n2);
    }

    @Override
    protected void engineUpdate(ByteBuffer byteBuffer) {
        this.buffer.write(byteBuffer);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        try {
            byte[] byArray = this.key_.use(l -> EvpSignatureRaw.signRaw(l, this.paddingType_, 0L, 0, this.buffer.getDataBuffer(), 0, this.buffer.size()));
            return byArray;
        }
        finally {
            this.engineReset();
        }
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        return this.engineVerify(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean engineVerify(byte[] byArray, int n, int n2) throws SignatureException {
        try {
            boolean bl = this.key_.use(l -> EvpSignatureRaw.verifyRaw(l, this.paddingType_, 0L, 0, this.buffer.getDataBuffer(), 0, this.buffer.size(), byArray, n, n2));
            return bl;
        }
        finally {
            this.engineReset();
        }
    }

    @Override
    protected boolean isBufferEmpty() {
        return this.buffer.size() == 0;
    }

    private static native byte[] signRaw(long var0, int var2, long var3, int var5, byte[] var6, int var7, int var8);

    private static native boolean verifyRaw(long var0, int var2, long var3, int var5, byte[] var6, int var7, int var8, byte[] var9, int var10, int var11) throws SignatureException;

    static final class NONEwithECDSA
    extends EvpSignatureRaw {
        NONEwithECDSA(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(amazonCorrettoCryptoProvider, EvpKeyType.EC, 0);
        }
    }
}

