/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.algo.graph.shortestpath;

import org.psjava.algo.graph.shortestpath.AllPairShortestPath;
import org.psjava.algo.graph.shortestpath.AllPairShortestPathResult;
import org.psjava.algo.graph.shortestpath.BellmanFordAlgorithm;
import org.psjava.algo.graph.shortestpath.DijkstraAlgorithm;
import org.psjava.algo.graph.shortestpath.SingleSourceShortestPathResult;
import org.psjava.ds.Collection;
import org.psjava.ds.graph.AllEdgeInGraph;
import org.psjava.ds.graph.DirectedWeightedEdge;
import org.psjava.ds.graph.Graph;
import org.psjava.ds.graph.MutableDirectedWeightedGraph;
import org.psjava.ds.map.MutableMap;
import org.psjava.ds.numbersystrem.AddableNumberSystem;
import org.psjava.goods.GoodMutableMapFactory;
import org.psjava.util.ConvertedDataIterable;
import org.psjava.util.DataConverter;

public class JohnsonAlgorithm {
    private static final Object VIRTUAL_START = new Object();

    public static AllPairShortestPath getInstance(final BellmanFordAlgorithm bellmanFord, final DijkstraAlgorithm dijkstra) {
        return new AllPairShortestPath(){

            @Override
            public <V, W, E extends DirectedWeightedEdge<V, W>> AllPairShortestPathResult<V, W, E> calc(Graph<V, E> graph, AddableNumberSystem<W> ns) {
                Graph augmented = JohnsonAlgorithm.augment(graph, ns);
                SingleSourceShortestPathResult bellmanFordResult = bellmanFord.calc(augmented, VIRTUAL_START, ns);
                Graph reweighted = JohnsonAlgorithm.reweight(graph, bellmanFordResult, ns);
                MutableMap dijsktraResult = GoodMutableMapFactory.getInstance().create();
                for (Object v : graph.getVertices()) {
                    dijsktraResult.add(v, dijkstra.calc(reweighted, v, ns));
                }
                return JohnsonAlgorithm.createUnreweightedResult(bellmanFordResult, dijsktraResult, ns);
            }
        };
    }

    private static <V, W, E extends DirectedWeightedEdge<V, W>> Graph<Object, DirectedWeightedEdge<Object, W>> augment(Graph<V, E> original, AddableNumberSystem<W> ns) {
        MutableDirectedWeightedGraph res = MutableDirectedWeightedGraph.create();
        res.insertVertex(VIRTUAL_START);
        for (Object v : original.getVertices()) {
            res.insertVertex(v);
            res.addEdge(VIRTUAL_START, v, ns.getZero());
        }
        for (DirectedWeightedEdge e : AllEdgeInGraph.wrap(original)) {
            res.addEdge(e.from(), e.to(), e.weight());
        }
        return res;
    }

    private static <V, W, E extends DirectedWeightedEdge<V, W>> Graph<V, ReweightedEdge<V, W, E>> reweight(final Graph<V, E> original, final SingleSourceShortestPathResult<Object, W, DirectedWeightedEdge<Object, W>> bellmanFordResult, final AddableNumberSystem<W> ns) {
        return new Graph<V, ReweightedEdge<V, W, E>>(){

            @Override
            public Collection<V> getVertices() {
                return original.getVertices();
            }

            @Override
            public Iterable<ReweightedEdge<V, W, E>> getEdges(V v) {
                return ConvertedDataIterable.create(original.getEdges(v), new DataConverter<E, ReweightedEdge<V, W, E>>(){

                    @Override
                    public ReweightedEdge<V, W, E> convert(E e) {
                        Object adjust = ns.subtract(bellmanFordResult.getDistance(e.from()), bellmanFordResult.getDistance(e.to()));
                        return new ReweightedEdge(ns.add(e.weight(), adjust), e);
                    }
                });
            }
        };
    }

    private static <V, W, E extends DirectedWeightedEdge<V, W>> AllPairShortestPathResult<V, W, E> createUnreweightedResult(final SingleSourceShortestPathResult<Object, W, DirectedWeightedEdge<Object, W>> bellmanFordResult, final MutableMap<V, SingleSourceShortestPathResult<V, W, ReweightedEdge<V, W, E>>> dijkstraResult, final AddableNumberSystem<W> ns) {
        return new AllPairShortestPathResult<V, W, E>(){

            @Override
            public W getDistance(V from, V to) {
                Object adjust = ns.subtract(bellmanFordResult.getDistance(to), bellmanFordResult.getDistance(from));
                return ns.add(((SingleSourceShortestPathResult)dijkstraResult.get(from)).getDistance(to), adjust);
            }

            @Override
            public Iterable<E> getPath(V from, V to) {
                return ConvertedDataIterable.create(((SingleSourceShortestPathResult)dijkstraResult.get(from)).getPath(to), new DataConverter<ReweightedEdge<V, W, E>, E>(){

                    @Override
                    public E convert(ReweightedEdge<V, W, E> v) {
                        return v.getOriginal();
                    }
                });
            }

            @Override
            public boolean isReachable(V from, V to) {
                return ((SingleSourceShortestPathResult)dijkstraResult.get(from)).isReachable(to);
            }
        };
    }

    private static class ReweightedEdge<V, W, E extends DirectedWeightedEdge<V, W>>
    implements DirectedWeightedEdge<V, W> {
        private final W weight;
        private final E original;

        ReweightedEdge(W w, E original) {
            this.weight = w;
            this.original = original;
        }

        @Override
        public V from() {
            return this.original.from();
        }

        @Override
        public V to() {
            return this.original.to();
        }

        @Override
        public W weight() {
            return this.weight;
        }

        public E getOriginal() {
            return this.original;
        }
    }
}

