/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.snapshot;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import org.apache.cassandra.config.DurationSpec;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.utils.FBUtilities;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
@JsonIgnoreProperties(ignoreUnknown=true)
public class SnapshotManifest {
    @JsonProperty(value="files")
    public final List<String> files;
    @JsonProperty(value="created_at")
    public final Instant createdAt;
    @JsonProperty(value="expires_at")
    public final Instant expiresAt;

    private SnapshotManifest() {
        this.files = null;
        this.createdAt = null;
        this.expiresAt = null;
    }

    public SnapshotManifest(List<String> files, DurationSpec.IntSecondsBound ttl, Instant creationTime) {
        this.files = files;
        this.createdAt = creationTime;
        this.expiresAt = ttl == null ? null : this.createdAt.plusSeconds(ttl.toSeconds());
    }

    public List<String> getFiles() {
        return this.files;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public Instant getExpiresAt() {
        return this.expiresAt;
    }

    public void serializeToJsonFile(File outputFile) throws IOException {
        FBUtilities.serializeToJsonFile(this, outputFile);
    }

    public static SnapshotManifest deserializeFromJsonFile(File file) throws IOException {
        return FBUtilities.deserializeFromJsonFile(SnapshotManifest.class, file);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotManifest manifest = (SnapshotManifest)o;
        return Objects.equals(this.files, manifest.files) && Objects.equals(this.createdAt, manifest.createdAt) && Objects.equals(this.expiresAt, manifest.expiresAt);
    }

    public int hashCode() {
        return Objects.hash(this.files, this.createdAt, this.expiresAt);
    }
}

