/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht.tokenallocator;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.dht.tokenallocator.TokenAllocation;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.SimpleSnitch;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.utils.OutputHandler;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;

public class OfflineTokenAllocator {
    public static List<FakeNode> allocate(int rf, int numTokens, int[] nodesPerRack, OutputHandler logger, IPartitioner partitioner) {
        Preconditions.checkArgument((rf > 0 ? 1 : 0) != 0, (Object)"rf must be greater than zero");
        Preconditions.checkArgument((numTokens > 0 ? 1 : 0) != 0, (Object)"num_tokens must be greater than zero");
        Preconditions.checkNotNull((Object)nodesPerRack);
        Preconditions.checkArgument((nodesPerRack.length > 0 ? 1 : 0) != 0, (Object)"nodesPerRack must contain a node count for at least one rack");
        Preconditions.checkNotNull((Object)logger);
        Preconditions.checkNotNull((Object)partitioner);
        int nodes = Arrays.stream(nodesPerRack).sum();
        Preconditions.checkArgument((nodes >= rf ? 1 : 0) != 0, (String)"not enough nodes %s for rf %s in %s", (Object)Arrays.stream(nodesPerRack).sum(), (Object)rf, (Object)Arrays.toString(nodesPerRack));
        ArrayList<FakeNode> fakeNodes = new ArrayList<FakeNode>(nodes);
        MultinodeAllocator allocator = new MultinodeAllocator(rf, numTokens, logger, partitioner);
        nodesPerRack = Arrays.copyOf(nodesPerRack, nodesPerRack.length);
        int racks = nodesPerRack.length;
        int nodeId = 0;
        int rackId = 0;
        while (nodesPerRack[rackId] > 0) {
            fakeNodes.add(allocator.allocateTokensForNode(nodeId++, rackId));
            int nextRack = (rackId + 1) % racks;
            while (nodesPerRack[nextRack] == 0 && nextRack != rackId) {
                nextRack = (nextRack + 1) % racks;
            }
            int n = rackId;
            nodesPerRack[n] = nodesPerRack[n] - 1;
            rackId = nextRack;
        }
        return fakeNodes;
    }

    private static InetAddressAndPort getLoopbackAddressWithPort(int port) {
        try {
            return InetAddressAndPort.getByAddressOverrideDefaults(InetAddress.getByName("127.0.0.1"), port);
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("Unexpected UnknownHostException", e);
        }
    }

    private static class FakeSnitch
    extends SimpleSnitch {
        final Map<InetAddressAndPort, Integer> nodeByRack = new HashMap<InetAddressAndPort, Integer>();

        private FakeSnitch() {
        }

        @Override
        public String getRack(InetAddressAndPort endpoint) {
            return Integer.toString(this.nodeByRack.get(endpoint));
        }
    }

    private static class MultinodeAllocator {
        private final FakeSnitch fakeSnitch;
        private final TokenMetadata fakeMetadata;
        private final TokenAllocation allocation;
        private final Map<Integer, SummaryStatistics> lastCheckPoint = Maps.newHashMap();
        private final OutputHandler logger;

        private MultinodeAllocator(int rf, int numTokens, OutputHandler logger, IPartitioner partitioner) {
            this.fakeSnitch = new FakeSnitch();
            this.fakeMetadata = new TokenMetadata(this.fakeSnitch).cloneWithNewPartitioner(partitioner);
            this.allocation = TokenAllocation.create(this.fakeSnitch, this.fakeMetadata, rf, numTokens);
            this.logger = logger;
        }

        private FakeNode allocateTokensForNode(int nodeId, Integer rackId) {
            InetAddressAndPort fakeNodeAddressAndPort = OfflineTokenAllocator.getLoopbackAddressWithPort(nodeId);
            this.fakeSnitch.nodeByRack.put(fakeNodeAddressAndPort, rackId);
            this.fakeMetadata.updateTopology(fakeNodeAddressAndPort);
            Collection<Token> tokens = this.allocation.allocate(fakeNodeAddressAndPort);
            this.validateAllocation(nodeId, rackId);
            return new FakeNode(fakeNodeAddressAndPort, rackId, tokens);
        }

        private void validateAllocation(int nodeId, int rackId) {
            double stdDevGrowth;
            SummaryStatistics newOwnership = this.allocation.getAllocationRingOwnership("datacenter1", Integer.toString(rackId));
            SummaryStatistics oldOwnership = this.lastCheckPoint.put(rackId, newOwnership);
            if (oldOwnership != null) {
                this.logger.debug(String.format("Replicated node load in rack=%d before allocating node %d: %s.", rackId, nodeId, TokenAllocation.statToString(oldOwnership)));
            }
            this.logger.debug(String.format("Replicated node load in rack=%d after allocating node %d: %s.", rackId, nodeId, TokenAllocation.statToString(newOwnership)));
            if (oldOwnership != null && oldOwnership.getStandardDeviation() != 0.0 && (stdDevGrowth = newOwnership.getStandardDeviation() - oldOwnership.getStandardDeviation()) > 0.05) {
                this.logger.warn(String.format("Growth of %.2f%% in token ownership standard deviation after allocating node %d on rack %d above warning threshold of %d%%", stdDevGrowth * 100.0, nodeId, rackId, 5));
            }
        }
    }

    public static class FakeNode {
        private final InetAddressAndPort fakeAddressAndPort;
        private final int rackId;
        private final Collection<Token> tokens;

        public FakeNode(InetAddressAndPort address, Integer rackId, Collection<Token> tokens) {
            this.fakeAddressAndPort = address;
            this.rackId = rackId;
            this.tokens = new TreeSet<Token>(tokens);
        }

        public int nodeId() {
            return this.fakeAddressAndPort.getPort();
        }

        public int rackId() {
            return this.rackId;
        }

        public Collection<Token> tokens() {
            return this.tokens;
        }
    }
}

