/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.guardrails;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.guardrails.GuardrailViolatedException;
import org.apache.cassandra.db.guardrails.GuardrailsDiagnostics;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.ClientWarn;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.NoSpamLogger;
import org.slf4j.LoggerFactory;

public abstract class Guardrail {
    protected static final NoSpamLogger logger = NoSpamLogger.getLogger(LoggerFactory.getLogger(Guardrail.class), 10L, TimeUnit.MINUTES);
    protected static final String REDACTED = "<redacted>";
    public final String name;
    private long minNotifyIntervalInMs = 0L;
    private volatile long lastWarnInMs = 0L;
    private volatile long lastFailInMs = 0L;

    Guardrail(String name) {
        this.name = name;
    }

    public boolean enabled() {
        return this.enabled(null);
    }

    public boolean enabled(@Nullable ClientState state) {
        return DatabaseDescriptor.isDaemonInitialized() && (state == null || state.isOrdinaryUser());
    }

    protected void warn(String message) {
        this.warn(message, message);
    }

    protected void warn(String message, String redactedMessage) {
        if (this.skipNotifying(true)) {
            return;
        }
        message = this.decorateMessage(message);
        logger.warn(message, new Object[0]);
        ClientWarn.instance.warn(message);
        Tracing.trace(message);
        GuardrailsDiagnostics.warned(this.name, this.decorateMessage(redactedMessage));
    }

    protected void fail(String message, @Nullable ClientState state) {
        this.fail(message, message, state);
    }

    protected void fail(String message, String redactedMessage, @Nullable ClientState state) {
        message = this.decorateMessage(message);
        if (!this.skipNotifying(false)) {
            logger.error(message, new Object[0]);
            ClientWarn.instance.warn(message);
            Tracing.trace(message);
            GuardrailsDiagnostics.failed(this.name, this.decorateMessage(redactedMessage));
        }
        if (state != null) {
            throw new GuardrailViolatedException(message);
        }
    }

    @VisibleForTesting
    String decorateMessage(String message) {
        return String.format("Guardrail %s violated: %s", this.name, message);
    }

    Guardrail minNotifyIntervalInMs(long minNotifyIntervalInMs) {
        assert (minNotifyIntervalInMs >= 0L);
        this.minNotifyIntervalInMs = minNotifyIntervalInMs;
        return this;
    }

    @VisibleForTesting
    void resetLastNotifyTime() {
        this.lastFailInMs = 0L;
        this.lastWarnInMs = 0L;
    }

    private boolean skipNotifying(boolean isWarn) {
        boolean skip;
        if (this.minNotifyIntervalInMs == 0L) {
            return false;
        }
        long nowInMs = Clock.Global.currentTimeMillis();
        long timeElapsedInMs = nowInMs - (isWarn ? this.lastWarnInMs : this.lastFailInMs);
        boolean bl = skip = timeElapsedInMs < this.minNotifyIntervalInMs;
        if (!skip) {
            if (isWarn) {
                this.lastWarnInMs = nowInMs;
            } else {
                this.lastFailInMs = nowInMs;
            }
        }
        return skip;
    }
}

