/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.report;

import org.apache.cassandra.stress.StressAction;
import org.apache.cassandra.utils.Clock;

public final class Timer {
    private final String opType;
    private final StressAction.MeasurementSink sink;
    private long intendedTimeNs;
    private long startTimeNs;

    public Timer(String opType, StressAction.MeasurementSink sink) {
        this.opType = opType;
        this.sink = sink;
    }

    public void stop(long partitionCount, long rowCount, boolean error) {
        this.sink.record(this.opType, this.intendedTimeNs, this.startTimeNs, Clock.Global.nanoTime(), rowCount, partitionCount, error);
        this.resetTimes();
    }

    private void resetTimes() {
        this.startTimeNs = 0L;
        this.intendedTimeNs = 0L;
    }

    public void intendedTimeNs(long v) {
        this.intendedTimeNs = v;
    }

    public void start() {
        this.startTimeNs = Clock.Global.nanoTime();
    }
}

